/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.IPSetSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IPSetSummaryMarshaller {
    private static final MarshallingInfo<String> IPSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final IPSetSummaryMarshaller INSTANCE = new IPSetSummaryMarshaller();

    private IPSetSummaryMarshaller() {
    }

    public static IPSetSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IPSetSummary ipSetSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ipSetSummary, (String)"ipSetSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ipSetSummary.ipSetId(), IPSETID_BINDING);
            protocolMarshaller.marshall((Object)ipSetSummary.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

