/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FieldToMatchMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").isBinary(false).build();
    private static final FieldToMatchMarshaller INSTANCE = new FieldToMatchMarshaller();

    private FieldToMatchMarshaller() {
    }

    public static FieldToMatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FieldToMatch fieldToMatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fieldToMatch, (String)"fieldToMatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fieldToMatch.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)fieldToMatch.data(), DATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

