/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.transform.WebACLSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACLSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACLSummary> {
    private final String webACLId;
    private final String name;

    private WebACLSummary(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.name = builder.name;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLSummary)) {
            return false;
        }
        WebACLSummary other = (WebACLSummary)obj;
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"WebACLSummary").add("WebACLId", (Object)this.webACLId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String webACLId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLSummary model) {
            this.webACLId(model.webACLId);
            this.name(model.name);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public WebACLSummary build() {
            return new WebACLSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACLSummary> {
        public Builder webACLId(String var1);

        public Builder name(String var1);
    }
}

