/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.GeoMatchSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateGeoMatchSetRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateGeoMatchSetRequest> {
    private final String geoMatchSetId;
    private final String changeToken;
    private final List<GeoMatchSetUpdate> updates;

    private UpdateGeoMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.geoMatchSetId = builder.geoMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String geoMatchSetId() {
        return this.geoMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<GeoMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGeoMatchSetRequest)) {
            return false;
        }
        UpdateGeoMatchSetRequest other = (UpdateGeoMatchSetRequest)((Object)obj);
        return Objects.equals(this.geoMatchSetId(), other.geoMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGeoMatchSetRequest").add("GeoMatchSetId", (Object)this.geoMatchSetId()).add("ChangeToken", (Object)this.changeToken()).add("Updates", this.updates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeoMatchSetId": {
                return Optional.of(clazz.cast(this.geoMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String geoMatchSetId;
        private String changeToken;
        private List<GeoMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGeoMatchSetRequest model) {
            this.geoMatchSetId(model.geoMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getGeoMatchSetId() {
            return this.geoMatchSetId;
        }

        @Override
        public final Builder geoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        public final void setGeoMatchSetId(String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<GeoMatchSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(GeoMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<GeoMatchSetUpdate> updates) {
            this.updates = GeoMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(GeoMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<GeoMatchSetUpdate.BuilderImpl> updates) {
            this.updates = GeoMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateGeoMatchSetRequest build() {
            return new UpdateGeoMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateGeoMatchSetRequest> {
        public Builder geoMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<GeoMatchSetUpdate> var1);

        public Builder updates(GeoMatchSetUpdate ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

