/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple;
import software.amazon.awssdk.services.waf.transform.SqlInjectionMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SqlInjectionMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, SqlInjectionMatchSetUpdate> {
    private final String action;
    private final SqlInjectionMatchTuple sqlInjectionMatchTuple;

    private SqlInjectionMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.sqlInjectionMatchTuple = builder.sqlInjectionMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public SqlInjectionMatchTuple sqlInjectionMatchTuple() {
        return this.sqlInjectionMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchTuple());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSetUpdate)) {
            return false;
        }
        SqlInjectionMatchSetUpdate other = (SqlInjectionMatchSetUpdate)obj;
        return Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.sqlInjectionMatchTuple(), other.sqlInjectionMatchTuple());
    }

    public String toString() {
        return ToString.builder((String)"SqlInjectionMatchSetUpdate").add("Action", (Object)this.actionString()).add("SqlInjectionMatchTuple", (Object)this.sqlInjectionMatchTuple()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "SqlInjectionMatchTuple": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchTuple()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqlInjectionMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private SqlInjectionMatchTuple sqlInjectionMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSetUpdate model) {
            this.action(model.action);
            this.sqlInjectionMatchTuple(model.sqlInjectionMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final SqlInjectionMatchTuple.Builder getSqlInjectionMatchTuple() {
            return this.sqlInjectionMatchTuple != null ? this.sqlInjectionMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple;
            return this;
        }

        public final void setSqlInjectionMatchTuple(SqlInjectionMatchTuple.BuilderImpl sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple != null ? sqlInjectionMatchTuple.build() : null;
        }

        public SqlInjectionMatchSetUpdate build() {
            return new SqlInjectionMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SqlInjectionMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple var1);

        default public Builder sqlInjectionMatchTuple(Consumer<SqlInjectionMatchTuple.Builder> sqlInjectionMatchTuple) {
            return this.sqlInjectionMatchTuple((SqlInjectionMatchTuple)((SqlInjectionMatchTuple.Builder)SqlInjectionMatchTuple.builder().apply(sqlInjectionMatchTuple)).build());
        }
    }
}

