/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.waf.model.ResourceArnsCopier;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourcesForWebACLResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListResourcesForWebACLResponse> {
    private final List<String> resourceArns;

    private ListResourcesForWebACLResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForWebACLResponse)) {
            return false;
        }
        ListResourcesForWebACLResponse other = (ListResourcesForWebACLResponse)((Object)obj);
        return Objects.equals(this.resourceArns(), other.resourceArns());
    }

    public String toString() {
        return ToString.builder((String)"ListResourcesForWebACLResponse").add("ResourceArns", this.resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArns": {
                return Optional.of(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private List<String> resourceArns;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForWebACLResponse model) {
            this.resourceArns(model.resourceArns);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public ListResourcesForWebACLResponse build() {
            return new ListResourcesForWebACLResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListResourcesForWebACLResponse> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);
    }
}

