/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.IPSetUpdate;
import software.amazon.awssdk.services.waf.model.IPSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateIPSetRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateIPSetRequest> {
    private final String ipSetId;
    private final String changeToken;
    private final List<IPSetUpdate> updates;

    private UpdateIPSetRequest(BuilderImpl builder) {
        super(builder);
        this.ipSetId = builder.ipSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<IPSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIPSetRequest)) {
            return false;
        }
        UpdateIPSetRequest other = (UpdateIPSetRequest)((Object)obj);
        return Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ipSetId() != null) {
            sb.append("IPSetId: ").append(this.ipSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetId": {
                return Optional.of(clazz.cast(this.ipSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String ipSetId;
        private String changeToken;
        private List<IPSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIPSetRequest model) {
            this.ipSetId(model.ipSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<IPSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(IPSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<IPSetUpdate> updates) {
            this.updates = IPSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(IPSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<IPSetUpdate.BuilderImpl> updates) {
            this.updates = IPSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateIPSetRequest build() {
            return new UpdateIPSetRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateIPSetRequest> {
        public Builder ipSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<IPSetUpdate> var1);

        public Builder updates(IPSetUpdate ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

