/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.waf.model.RegexMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.RegexMatchSetSummary;
import software.amazon.awssdk.services.waf.model.WAFResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRegexMatchSetsResponse
extends WAFResponse
implements ToCopyableBuilder<Builder, ListRegexMatchSetsResponse> {
    private final String nextMarker;
    private final List<RegexMatchSetSummary> regexMatchSets;

    private ListRegexMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexMatchSets = builder.regexMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RegexMatchSetSummary> regexMatchSets() {
        return this.regexMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexMatchSetsResponse)) {
            return false;
        }
        ListRegexMatchSetsResponse other = (ListRegexMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.regexMatchSets(), other.regexMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.regexMatchSets() != null) {
            sb.append("RegexMatchSets: ").append(this.regexMatchSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "RegexMatchSets": {
                return Optional.of(clazz.cast(this.regexMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RegexMatchSetSummary> regexMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.regexMatchSets(model.regexMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RegexMatchSetSummary.Builder> getRegexMatchSets() {
            return this.regexMatchSets != null ? (Collection)this.regexMatchSets.stream().map(RegexMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regexMatchSets(Collection<RegexMatchSetSummary> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copy(regexMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchSets(RegexMatchSetSummary ... regexMatchSets) {
            this.regexMatchSets(Arrays.asList(regexMatchSets));
            return this;
        }

        public final void setRegexMatchSets(Collection<RegexMatchSetSummary.BuilderImpl> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copyFromBuilder(regexMatchSets);
        }

        @Override
        public ListRegexMatchSetsResponse build() {
            return new ListRegexMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends WAFResponse.Builder,
    CopyableBuilder<Builder, ListRegexMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder regexMatchSets(Collection<RegexMatchSetSummary> var1);

        public Builder regexMatchSets(RegexMatchSetSummary ... var1);
    }
}

