/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRuleRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private final String name;
    private final String metricName;
    private final String changeToken;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.changeToken = builder.changeToken;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public String changeToken() {
        return this.changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String name;
        private String metricName;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            this.name(model.name);
            this.metricName(model.metricName);
            this.changeToken(model.changeToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder changeToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

