/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.SqlInjectionMatchSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SqlInjectionMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, SqlInjectionMatchSet> {
    private final String sqlInjectionMatchSetId;
    private final String name;
    private final List<SqlInjectionMatchTuple> sqlInjectionMatchTuples;

    private SqlInjectionMatchSet(BuilderImpl builder) {
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.name = builder.name;
        this.sqlInjectionMatchTuples = builder.sqlInjectionMatchTuples;
    }

    public String sqlInjectionMatchSetId() {
        return this.sqlInjectionMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<SqlInjectionMatchTuple> sqlInjectionMatchTuples() {
        return this.sqlInjectionMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchTuples());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSet)) {
            return false;
        }
        SqlInjectionMatchSet other = (SqlInjectionMatchSet)obj;
        return Objects.equals(this.sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sqlInjectionMatchTuples(), other.sqlInjectionMatchTuples());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sqlInjectionMatchSetId() != null) {
            sb.append("SqlInjectionMatchSetId: ").append(this.sqlInjectionMatchSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.sqlInjectionMatchTuples() != null) {
            sb.append("SqlInjectionMatchTuples: ").append(this.sqlInjectionMatchTuples()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlInjectionMatchSetId": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SqlInjectionMatchTuples": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchTuples()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqlInjectionMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sqlInjectionMatchSetId;
        private String name;
        private List<SqlInjectionMatchTuple> sqlInjectionMatchTuples;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSet model) {
            this.sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            this.name(model.name);
            this.sqlInjectionMatchTuples(model.sqlInjectionMatchTuples);
        }

        public final String getSqlInjectionMatchSetId() {
            return this.sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SqlInjectionMatchTuple.Builder> getSqlInjectionMatchTuples() {
            return this.sqlInjectionMatchTuples != null ? (Collection)this.sqlInjectionMatchTuples.stream().map(SqlInjectionMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copy(sqlInjectionMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple ... sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples(Arrays.asList(sqlInjectionMatchTuples));
            return this;
        }

        public final void setSqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple.BuilderImpl> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = SqlInjectionMatchTuplesCopier.copyFromBuilder(sqlInjectionMatchTuples);
        }

        public SqlInjectionMatchSet build() {
            return new SqlInjectionMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SqlInjectionMatchSet> {
        public Builder sqlInjectionMatchSetId(String var1);

        public Builder name(String var1);

        public Builder sqlInjectionMatchTuples(Collection<SqlInjectionMatchTuple> var1);

        public Builder sqlInjectionMatchTuples(SqlInjectionMatchTuple ... var1);
    }
}

