/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.RuleSummariesCopier;
import software.amazon.awssdk.services.waf.model.RuleSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRateBasedRulesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRateBasedRulesResponse> {
    private final String nextMarker;
    private final List<RuleSummary> rules;

    private ListRateBasedRulesResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.rules = builder.rules;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RuleSummary> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRateBasedRulesResponse)) {
            return false;
        }
        ListRateBasedRulesResponse other = (ListRateBasedRulesResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RuleSummary> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRateBasedRulesResponse model) {
            this.nextMarker(model.nextMarker);
            this.rules(model.rules);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RuleSummary.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(RuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        public ListRateBasedRulesResponse build() {
            return new ListRateBasedRulesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRateBasedRulesResponse> {
        public Builder nextMarker(String var1);

        public Builder rules(Collection<RuleSummary> var1);

        public Builder rules(RuleSummary ... var1);
    }
}

