/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.IPSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.IPSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIPSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIPSetsResponse> {
    private final String nextMarker;
    private final List<IPSetSummary> ipSets;

    private ListIPSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.ipSets = builder.ipSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<IPSetSummary> ipSets() {
        return this.ipSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIPSetsResponse)) {
            return false;
        }
        ListIPSetsResponse other = (ListIPSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.ipSets(), other.ipSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.ipSets() != null) {
            sb.append("IPSets: ").append(this.ipSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "IPSets": {
                return Optional.of(clazz.cast(this.ipSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<IPSetSummary> ipSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIPSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.ipSets(model.ipSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<IPSetSummary.Builder> getIPSets() {
            return this.ipSets != null ? (Collection)this.ipSets.stream().map(IPSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IPSetSummary ... ipSets) {
            this.ipSets(Arrays.asList(ipSets));
            return this;
        }

        public final void setIPSets(Collection<IPSetSummary.BuilderImpl> ipSets) {
            this.ipSets = IPSetSummariesCopier.copyFromBuilder(ipSets);
        }

        public ListIPSetsResponse build() {
            return new ListIPSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIPSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder ipSets(Collection<IPSetSummary> var1);

        public Builder ipSets(IPSetSummary ... var1);
    }
}

