/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListByteMatchSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListByteMatchSetsResponse> {
    private final String nextMarker;
    private final List<ByteMatchSetSummary> byteMatchSets;

    private ListByteMatchSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.byteMatchSets = builder.byteMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<ByteMatchSetSummary> byteMatchSets() {
        return this.byteMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.byteMatchSets() == null ? 0 : this.byteMatchSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListByteMatchSetsResponse)) {
            return false;
        }
        ListByteMatchSetsResponse other = (ListByteMatchSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.byteMatchSets() == null ^ this.byteMatchSets() == null) {
            return false;
        }
        return other.byteMatchSets() == null || other.byteMatchSets().equals(this.byteMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.byteMatchSets() != null) {
            sb.append("ByteMatchSets: ").append(this.byteMatchSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "ByteMatchSets": {
                return Optional.of(clazz.cast(this.byteMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ByteMatchSetSummary> byteMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListByteMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.byteMatchSets(model.byteMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<ByteMatchSetSummary.Builder> getByteMatchSets() {
            return this.byteMatchSets != null ? (Collection)this.byteMatchSets.stream().map(ByteMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copy(byteMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(ByteMatchSetSummary ... byteMatchSets) {
            this.byteMatchSets(Arrays.asList(byteMatchSets));
            return this;
        }

        public final void setByteMatchSets(Collection<ByteMatchSetSummary.BuilderImpl> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copyFromBuilder(byteMatchSets);
        }

        public ListByteMatchSetsResponse build() {
            return new ListByteMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListByteMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder byteMatchSets(Collection<ByteMatchSetSummary> var1);

        public Builder byteMatchSets(ByteMatchSetSummary ... var1);
    }
}

