/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.transform.IPSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IPSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetUpdate> {
    private final String action;
    private final IPSetDescriptor ipSetDescriptor;

    private IPSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.ipSetDescriptor = builder.ipSetDescriptor;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public IPSetDescriptor ipSetDescriptor() {
        return this.ipSetDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionString() == null ? 0 : this.actionString().hashCode());
        hashCode = 31 * hashCode + (this.ipSetDescriptor() == null ? 0 : this.ipSetDescriptor().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetUpdate)) {
            return false;
        }
        IPSetUpdate other = (IPSetUpdate)obj;
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.ipSetDescriptor() == null ^ this.ipSetDescriptor() == null) {
            return false;
        }
        return other.ipSetDescriptor() == null || other.ipSetDescriptor().equals(this.ipSetDescriptor());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.ipSetDescriptor() != null) {
            sb.append("IPSetDescriptor: ").append(this.ipSetDescriptor()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "IPSetDescriptor": {
                return Optional.of(clazz.cast(this.ipSetDescriptor()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private IPSetDescriptor ipSetDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetUpdate model) {
            this.action(model.action);
            this.ipSetDescriptor(model.ipSetDescriptor);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final IPSetDescriptor.Builder getIPSetDescriptor() {
            return this.ipSetDescriptor != null ? this.ipSetDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder ipSetDescriptor(IPSetDescriptor ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor;
            return this;
        }

        public final void setIPSetDescriptor(IPSetDescriptor.BuilderImpl ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor != null ? ipSetDescriptor.build() : null;
        }

        public IPSetUpdate build() {
            return new IPSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder ipSetDescriptor(IPSetDescriptor var1);
    }
}

