/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.SampledHTTPRequest;
import software.amazon.awssdk.services.waf.model.SampledHTTPRequestsCopier;
import software.amazon.awssdk.services.waf.model.TimeWindow;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSampledRequestsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetSampledRequestsResponse> {
    private final List<SampledHTTPRequest> sampledRequests;
    private final Long populationSize;
    private final TimeWindow timeWindow;

    private GetSampledRequestsResponse(BuilderImpl builder) {
        this.sampledRequests = builder.sampledRequests;
        this.populationSize = builder.populationSize;
        this.timeWindow = builder.timeWindow;
    }

    public List<SampledHTTPRequest> sampledRequests() {
        return this.sampledRequests;
    }

    public Long populationSize() {
        return this.populationSize;
    }

    public TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sampledRequests() == null ? 0 : this.sampledRequests().hashCode());
        hashCode = 31 * hashCode + (this.populationSize() == null ? 0 : this.populationSize().hashCode());
        hashCode = 31 * hashCode + (this.timeWindow() == null ? 0 : this.timeWindow().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsResponse)) {
            return false;
        }
        GetSampledRequestsResponse other = (GetSampledRequestsResponse)((Object)obj);
        if (other.sampledRequests() == null ^ this.sampledRequests() == null) {
            return false;
        }
        if (other.sampledRequests() != null && !other.sampledRequests().equals(this.sampledRequests())) {
            return false;
        }
        if (other.populationSize() == null ^ this.populationSize() == null) {
            return false;
        }
        if (other.populationSize() != null && !other.populationSize().equals(this.populationSize())) {
            return false;
        }
        if (other.timeWindow() == null ^ this.timeWindow() == null) {
            return false;
        }
        return other.timeWindow() == null || other.timeWindow().equals(this.timeWindow());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sampledRequests() != null) {
            sb.append("SampledRequests: ").append(this.sampledRequests()).append(",");
        }
        if (this.populationSize() != null) {
            sb.append("PopulationSize: ").append(this.populationSize()).append(",");
        }
        if (this.timeWindow() != null) {
            sb.append("TimeWindow: ").append(this.timeWindow()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SampledRequests": {
                return Optional.of(clazz.cast(this.sampledRequests()));
            }
            case "PopulationSize": {
                return Optional.of(clazz.cast(this.populationSize()));
            }
            case "TimeWindow": {
                return Optional.of(clazz.cast(this.timeWindow()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<SampledHTTPRequest> sampledRequests;
        private Long populationSize;
        private TimeWindow timeWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsResponse model) {
            this.sampledRequests(model.sampledRequests);
            this.populationSize(model.populationSize);
            this.timeWindow(model.timeWindow);
        }

        public final Collection<SampledHTTPRequest.Builder> getSampledRequests() {
            return this.sampledRequests != null ? (Collection)this.sampledRequests.stream().map(SampledHTTPRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sampledRequests(Collection<SampledHTTPRequest> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copy(sampledRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampledRequests(SampledHTTPRequest ... sampledRequests) {
            this.sampledRequests(Arrays.asList(sampledRequests));
            return this;
        }

        public final void setSampledRequests(Collection<SampledHTTPRequest.BuilderImpl> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copyFromBuilder(sampledRequests);
        }

        public final Long getPopulationSize() {
            return this.populationSize;
        }

        @Override
        public final Builder populationSize(Long populationSize) {
            this.populationSize = populationSize;
            return this;
        }

        public final void setPopulationSize(Long populationSize) {
            this.populationSize = populationSize;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        public GetSampledRequestsResponse build() {
            return new GetSampledRequestsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSampledRequestsResponse> {
        public Builder sampledRequests(Collection<SampledHTTPRequest> var1);

        public Builder sampledRequests(SampledHTTPRequest ... var1);

        public Builder populationSize(Long var1);

        public Builder timeWindow(TimeWindow var1);
    }
}

