/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.MatchFieldType;
import software.amazon.awssdk.services.waf.transform.FieldToMatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FieldToMatch
implements StructuredPojo,
ToCopyableBuilder<Builder, FieldToMatch> {
    private final String type;
    private final String data;

    private FieldToMatch(BuilderImpl builder) {
        this.type = builder.type;
        this.data = builder.data;
    }

    public MatchFieldType type() {
        return MatchFieldType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToMatch)) {
            return false;
        }
        FieldToMatch other = (FieldToMatch)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        return other.data() == null || other.data().equals(this.data());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldToMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToMatch model) {
            this.type(model.type);
            this.data(model.data);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MatchFieldType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public FieldToMatch build() {
            return new FieldToMatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FieldToMatch> {
        public Builder type(String var1);

        public Builder type(MatchFieldType var1);

        public Builder data(String var1);
    }
}

