/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.transform.FieldToMatchUnmarshaller;

public class ByteMatchTupleUnmarshaller
implements Unmarshaller<ByteMatchTuple, JsonUnmarshallerContext> {
    private static final ByteMatchTupleUnmarshaller INSTANCE = new ByteMatchTupleUnmarshaller();

    public ByteMatchTuple unmarshall(JsonUnmarshallerContext context) throws Exception {
        ByteMatchTuple.Builder byteMatchTupleBuilder = ByteMatchTuple.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("FieldToMatch", targetDepth)) {
                    context.nextToken();
                    byteMatchTupleBuilder.fieldToMatch(FieldToMatchUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TargetString", targetDepth)) {
                    context.nextToken();
                    byteMatchTupleBuilder.targetString((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("TextTransformation", targetDepth)) {
                    context.nextToken();
                    byteMatchTupleBuilder.textTransformation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PositionalConstraint", targetDepth)) {
                    context.nextToken();
                    byteMatchTupleBuilder.positionalConstraint((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ByteMatchTuple)byteMatchTupleBuilder.build();
    }

    public static ByteMatchTupleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

