/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ActivatedRulesCopier;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.transform.WebACLMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACL
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACL> {
    private final String webACLId;
    private final String name;
    private final String metricName;
    private final WafAction defaultAction;
    private final List<ActivatedRule> rules;

    private WebACL(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.defaultAction = builder.defaultAction;
        this.rules = builder.rules;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public WafAction defaultAction() {
        return this.defaultAction;
    }

    public List<ActivatedRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.webACLId() == null ? 0 : this.webACLId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.defaultAction() == null ? 0 : this.defaultAction().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACL)) {
            return false;
        }
        WebACL other = (WebACL)obj;
        if (other.webACLId() == null ^ this.webACLId() == null) {
            return false;
        }
        if (other.webACLId() != null && !other.webACLId().equals(this.webACLId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.defaultAction() == null ^ this.defaultAction() == null) {
            return false;
        }
        if (other.defaultAction() != null && !other.defaultAction().equals(this.defaultAction())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.defaultAction() != null) {
            sb.append("DefaultAction: ").append(this.defaultAction()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String webACLId;
        private String name;
        private String metricName;
        private WafAction defaultAction;
        private List<ActivatedRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACL model) {
            this.setWebACLId(model.webACLId);
            this.setName(model.name);
            this.setMetricName(model.metricName);
            this.setDefaultAction(model.defaultAction);
            this.setRules(model.rules);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final WafAction getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
        }

        public final Collection<ActivatedRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<ActivatedRule> rules) {
            this.rules = ActivatedRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ActivatedRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ActivatedRule> rules) {
            this.rules = ActivatedRulesCopier.copy(rules);
        }

        public WebACL build() {
            return new WebACL(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACL> {
        public Builder webACLId(String var1);

        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder defaultAction(WafAction var1);

        public Builder rules(Collection<ActivatedRule> var1);

        public Builder rules(ActivatedRule ... var1);
    }
}

