/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.ByteMatchSetUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateByteMatchSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateByteMatchSetRequest> {
    private final String byteMatchSetId;
    private final String changeToken;
    private final List<ByteMatchSetUpdate> updates;

    private UpdateByteMatchSetRequest(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<ByteMatchSetUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.byteMatchSetId() == null ? 0 : this.byteMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateByteMatchSetRequest)) {
            return false;
        }
        UpdateByteMatchSetRequest other = (UpdateByteMatchSetRequest)((Object)obj);
        if (other.byteMatchSetId() == null ^ this.byteMatchSetId() == null) {
            return false;
        }
        if (other.byteMatchSetId() != null && !other.byteMatchSetId().equals(this.byteMatchSetId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        return other.updates() == null || other.updates().equals(this.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.byteMatchSetId() != null) {
            sb.append("ByteMatchSetId: ").append(this.byteMatchSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String changeToken;
        private List<ByteMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateByteMatchSetRequest model) {
            this.setByteMatchSetId(model.byteMatchSetId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<ByteMatchSetUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<ByteMatchSetUpdate> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(ByteMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<ByteMatchSetUpdate> updates) {
            this.updates = ByteMatchSetUpdatesCopier.copy(updates);
        }

        public UpdateByteMatchSetRequest build() {
            return new UpdateByteMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateByteMatchSetRequest> {
        public Builder byteMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<ByteMatchSetUpdate> var1);

        public Builder updates(ByteMatchSetUpdate ... var1);
    }
}

