/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.IPSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.IPSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIPSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIPSetsResponse> {
    private final String nextMarker;
    private final List<IPSetSummary> ipSets;

    private ListIPSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.ipSets = builder.ipSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<IPSetSummary> ipSets() {
        return this.ipSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.ipSets() == null ? 0 : this.ipSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIPSetsResponse)) {
            return false;
        }
        ListIPSetsResponse other = (ListIPSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.ipSets() == null ^ this.ipSets() == null) {
            return false;
        }
        return other.ipSets() == null || other.ipSets().equals(this.ipSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.ipSets() != null) {
            sb.append("IPSets: ").append(this.ipSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<IPSetSummary> ipSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIPSetsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setIPSets(model.ipSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<IPSetSummary> getIPSets() {
            return this.ipSets;
        }

        @Override
        public final Builder ipSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IPSetSummary ... ipSets) {
            this.ipSets(Arrays.asList(ipSets));
            return this;
        }

        public final void setIPSets(Collection<IPSetSummary> ipSets) {
            this.ipSets = IPSetSummariesCopier.copy(ipSets);
        }

        public ListIPSetsResponse build() {
            return new ListIPSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIPSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder ipSets(Collection<IPSetSummary> var1);

        public Builder ipSets(IPSetSummary ... var1);
    }
}

