/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.model.IPSetDescriptorsCopier;
import software.amazon.awssdk.services.waf.transform.IPSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IPSet
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSet> {
    private final String ipSetId;
    private final String name;
    private final List<IPSetDescriptor> ipSetDescriptors;

    private IPSet(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
        this.ipSetDescriptors = builder.ipSetDescriptors;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public List<IPSetDescriptor> ipSetDescriptors() {
        return this.ipSetDescriptors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipSetId() == null ? 0 : this.ipSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.ipSetDescriptors() == null ? 0 : this.ipSetDescriptors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        if (other.ipSetId() == null ^ this.ipSetId() == null) {
            return false;
        }
        if (other.ipSetId() != null && !other.ipSetId().equals(this.ipSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ipSetDescriptors() == null ^ this.ipSetDescriptors() == null) {
            return false;
        }
        return other.ipSetDescriptors() == null || other.ipSetDescriptors().equals(this.ipSetDescriptors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipSetId() != null) {
            sb.append("IPSetId: ").append(this.ipSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.ipSetDescriptors() != null) {
            sb.append("IPSetDescriptors: ").append(this.ipSetDescriptors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;
        private List<IPSetDescriptor> ipSetDescriptors;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSet model) {
            this.setIPSetId(model.ipSetId);
            this.setName(model.name);
            this.setIPSetDescriptors(model.ipSetDescriptors);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<IPSetDescriptor> getIPSetDescriptors() {
            return this.ipSetDescriptors;
        }

        @Override
        public final Builder ipSetDescriptors(Collection<IPSetDescriptor> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copy(ipSetDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetDescriptors(IPSetDescriptor ... ipSetDescriptors) {
            this.ipSetDescriptors(Arrays.asList(ipSetDescriptors));
            return this;
        }

        public final void setIPSetDescriptors(Collection<IPSetDescriptor> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copy(ipSetDescriptors);
        }

        public IPSet build() {
            return new IPSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSet> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);

        public Builder ipSetDescriptors(Collection<IPSetDescriptor> var1);

        public Builder ipSetDescriptors(IPSetDescriptor ... var1);
    }
}

