/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.waf.model.WebACL;
import software.amazon.awssdk.services.waf.transform.ActivatedRuleUnmarshaller;
import software.amazon.awssdk.services.waf.transform.WafActionUnmarshaller;

public class WebACLUnmarshaller
implements Unmarshaller<WebACL, JsonUnmarshallerContext> {
    private static final WebACLUnmarshaller INSTANCE = new WebACLUnmarshaller();

    public WebACL unmarshall(JsonUnmarshallerContext context) throws Exception {
        WebACL.Builder webACLBuilder = WebACL.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("WebACLId", targetDepth)) {
                    context.nextToken();
                    webACLBuilder.webACLId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    webACLBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    context.nextToken();
                    webACLBuilder.metricName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultAction", targetDepth)) {
                    context.nextToken();
                    webACLBuilder.defaultAction(WafActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Rules", targetDepth)) {
                    context.nextToken();
                    webACLBuilder.rules(new ListUnmarshaller((Unmarshaller)ActivatedRuleUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (WebACL)webACLBuilder.build();
    }

    public static WebACLUnmarshaller getInstance() {
        return INSTANCE;
    }
}

