/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.WebACL;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WebACLMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAction").isBinary(false).build();
    private static final MarshallingInfo<List> RULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rules").isBinary(false).build();
    private static final WebACLMarshaller INSTANCE = new WebACLMarshaller();

    private WebACLMarshaller() {
    }

    public static WebACLMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WebACL webACL, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)webACL, (String)"webACL");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)webACL.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)webACL.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)webACL.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)webACL.defaultAction(), DEFAULTACTION_BINDING);
            protocolMarshaller.marshall(webACL.rules(), RULES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

