/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.UpdateRuleRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateRuleRequestModelMarshaller {
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleId").isBinary(false).build();
    private static final MarshallingInfo<String> CHANGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeToken").isBinary(false).build();
    private static final MarshallingInfo<List> UPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Updates").isBinary(false).build();
    private static final UpdateRuleRequestModelMarshaller INSTANCE = new UpdateRuleRequestModelMarshaller();

    private UpdateRuleRequestModelMarshaller() {
    }

    public static UpdateRuleRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateRuleRequest updateRuleRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateRuleRequest), (String)"updateRuleRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateRuleRequest.ruleId(), RULEID_BINDING);
            protocolMarshaller.marshall((Object)updateRuleRequest.changeToken(), CHANGETOKEN_BINDING);
            protocolMarshaller.marshall(updateRuleRequest.updates(), UPDATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

