/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.LoggingConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoggingConfigurationMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final MarshallingInfo<List> LOGDESTINATIONCONFIGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogDestinationConfigs").isBinary(false).build();
    private static final MarshallingInfo<List> REDACTEDFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedactedFields").isBinary(false).build();
    private static final LoggingConfigurationMarshaller INSTANCE = new LoggingConfigurationMarshaller();

    private LoggingConfigurationMarshaller() {
    }

    public static LoggingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LoggingConfiguration loggingConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)loggingConfiguration, (String)"loggingConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)loggingConfiguration.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(loggingConfiguration.logDestinationConfigs(), LOGDESTINATIONCONFIGS_BINDING);
            protocolMarshaller.marshall(loggingConfiguration.redactedFields(), REDACTEDFIELDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

