/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.IPSetUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IPSetUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IPSETDESCRIPTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPSetDescriptor").isBinary(false).build();
    private static final IPSetUpdateMarshaller INSTANCE = new IPSetUpdateMarshaller();

    private IPSetUpdateMarshaller() {
    }

    public static IPSetUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IPSetUpdate ipSetUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ipSetUpdate, (String)"ipSetUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ipSetUpdate.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)ipSetUpdate.ipSetDescriptor(), IPSETDESCRIPTOR_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

