/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.HTTPRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HTTPRequestMarshaller {
    private static final MarshallingInfo<String> CLIENTIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientIP").isBinary(false).build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").isBinary(false).build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URI").isBinary(false).build();
    private static final MarshallingInfo<String> METHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Method").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPVersion").isBinary(false).build();
    private static final MarshallingInfo<List> HEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Headers").isBinary(false).build();
    private static final HTTPRequestMarshaller INSTANCE = new HTTPRequestMarshaller();

    private HTTPRequestMarshaller() {
    }

    public static HTTPRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HTTPRequest httpRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)httpRequest, (String)"httpRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)httpRequest.clientIP(), CLIENTIP_BINDING);
            protocolMarshaller.marshall((Object)httpRequest.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)httpRequest.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)httpRequest.method(), METHOD_BINDING);
            protocolMarshaller.marshall((Object)httpRequest.httpVersion(), HTTPVERSION_BINDING);
            protocolMarshaller.marshall(httpRequest.headers(), HEADERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

