/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.RegexMatchSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRegexMatchSetRequest
extends WafRequest
implements ToCopyableBuilder<Builder, UpdateRegexMatchSetRequest> {
    private final String regexMatchSetId;
    private final List<RegexMatchSetUpdate> updates;
    private final String changeToken;

    private UpdateRegexMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexMatchSetId = builder.regexMatchSetId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    public String regexMatchSetId() {
        return this.regexMatchSetId;
    }

    public List<RegexMatchSetUpdate> updates() {
        return this.updates;
    }

    public String changeToken() {
        return this.changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegexMatchSetRequest)) {
            return false;
        }
        UpdateRegexMatchSetRequest other = (UpdateRegexMatchSetRequest)((Object)obj);
        return Objects.equals(this.regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRegexMatchSetRequest").add("RegexMatchSetId", (Object)this.regexMatchSetId()).add("Updates", this.updates()).add("ChangeToken", (Object)this.changeToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.regexMatchSetId()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String regexMatchSetId;
        private List<RegexMatchSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegexMatchSetRequest model) {
            super(model);
            this.regexMatchSetId(model.regexMatchSetId);
            this.updates(model.updates);
            this.changeToken(model.changeToken);
        }

        public final String getRegexMatchSetId() {
            return this.regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        public final Collection<RegexMatchSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(RegexMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<RegexMatchSetUpdate> updates) {
            this.updates = RegexMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(RegexMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<RegexMatchSetUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (RegexMatchSetUpdate)((RegexMatchSetUpdate.Builder)RegexMatchSetUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<RegexMatchSetUpdate.BuilderImpl> updates) {
            this.updates = RegexMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRegexMatchSetRequest build() {
            return new UpdateRegexMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    CopyableBuilder<Builder, UpdateRegexMatchSetRequest> {
        public Builder regexMatchSetId(String var1);

        public Builder updates(Collection<RegexMatchSetUpdate> var1);

        public Builder updates(RegexMatchSetUpdate ... var1);

        public Builder updates(Consumer<RegexMatchSetUpdate.Builder> ... var1);

        public Builder changeToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

