/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ComparisonOperator;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.services.waf.transform.SizeConstraintMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SizeConstraint
implements StructuredPojo,
ToCopyableBuilder<Builder, SizeConstraint> {
    private final FieldToMatch fieldToMatch;
    private final String textTransformation;
    private final String comparisonOperator;
    private final Long size;

    private SizeConstraint(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformation = builder.textTransformation;
        this.comparisonOperator = builder.comparisonOperator;
        this.size = builder.size;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public TextTransformation textTransformation() {
        return TextTransformation.fromValue(this.textTransformation);
    }

    public String textTransformationAsString() {
        return this.textTransformation;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraint)) {
            return false;
        }
        SizeConstraint other = (SizeConstraint)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.textTransformationAsString(), other.textTransformationAsString()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        return ToString.builder((String)"SizeConstraint").add("FieldToMatch", (Object)this.fieldToMatch()).add("TextTransformation", (Object)this.textTransformationAsString()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Size", (Object)this.size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformation": {
                return Optional.ofNullable(clazz.cast(this.textTransformationAsString()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SizeConstraintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private String textTransformation;
        private String comparisonOperator;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraint model) {
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformation(model.textTransformation);
            this.comparisonOperator(model.comparisonOperator);
            this.size(model.size);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public SizeConstraint build() {
            return new SizeConstraint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SizeConstraint> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder size(Long var1);
    }
}

