/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.LogDestinationConfigsCopier;
import software.amazon.awssdk.services.waf.model.RedactedFieldsCopier;
import software.amazon.awssdk.services.waf.transform.LoggingConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, LoggingConfiguration> {
    private final String resourceArn;
    private final List<String> logDestinationConfigs;
    private final List<FieldToMatch> redactedFields;

    private LoggingConfiguration(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.logDestinationConfigs = builder.logDestinationConfigs;
        this.redactedFields = builder.redactedFields;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<String> logDestinationConfigs() {
        return this.logDestinationConfigs;
    }

    public List<FieldToMatch> redactedFields() {
        return this.redactedFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.logDestinationConfigs(), other.logDestinationConfigs()) && Objects.equals(this.redactedFields(), other.redactedFields());
    }

    public String toString() {
        return ToString.builder((String)"LoggingConfiguration").add("ResourceArn", (Object)this.resourceArn()).add("LogDestinationConfigs", this.logDestinationConfigs()).add("RedactedFields", this.redactedFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "LogDestinationConfigs": {
                return Optional.ofNullable(clazz.cast(this.logDestinationConfigs()));
            }
            case "RedactedFields": {
                return Optional.ofNullable(clazz.cast(this.redactedFields()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> logDestinationConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<FieldToMatch> redactedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            this.resourceArn(model.resourceArn);
            this.logDestinationConfigs(model.logDestinationConfigs);
            this.redactedFields(model.redactedFields);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getLogDestinationConfigs() {
            return this.logDestinationConfigs;
        }

        @Override
        public final Builder logDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDestinationConfigs(String ... logDestinationConfigs) {
            this.logDestinationConfigs(Arrays.asList(logDestinationConfigs));
            return this;
        }

        public final void setLogDestinationConfigs(Collection<String> logDestinationConfigs) {
            this.logDestinationConfigs = LogDestinationConfigsCopier.copy(logDestinationConfigs);
        }

        public final Collection<FieldToMatch.Builder> getRedactedFields() {
            return this.redactedFields != null ? (Collection)this.redactedFields.stream().map(FieldToMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder redactedFields(Collection<FieldToMatch> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copy(redactedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(FieldToMatch ... redactedFields) {
            this.redactedFields(Arrays.asList(redactedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redactedFields(Consumer<FieldToMatch.Builder> ... redactedFields) {
            this.redactedFields(Stream.of(redactedFields).map(c -> (FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRedactedFields(Collection<FieldToMatch.BuilderImpl> redactedFields) {
            this.redactedFields = RedactedFieldsCopier.copyFromBuilder(redactedFields);
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingConfiguration> {
        public Builder resourceArn(String var1);

        public Builder logDestinationConfigs(Collection<String> var1);

        public Builder logDestinationConfigs(String ... var1);

        public Builder redactedFields(Collection<FieldToMatch> var1);

        public Builder redactedFields(FieldToMatch ... var1);

        public Builder redactedFields(Consumer<FieldToMatch.Builder> ... var1);
    }
}

