/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummariesCopier;
import software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscribedRuleGroupsResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListSubscribedRuleGroupsResponse> {
    private final String nextMarker;
    private final List<SubscribedRuleGroupSummary> ruleGroups;

    private ListSubscribedRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ruleGroups = builder.ruleGroups;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<SubscribedRuleGroupSummary> ruleGroups() {
        return this.ruleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribedRuleGroupsResponse)) {
            return false;
        }
        ListSubscribedRuleGroupsResponse other = (ListSubscribedRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.ruleGroups(), other.ruleGroups());
    }

    public String toString() {
        return ToString.builder((String)"ListSubscribedRuleGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("RuleGroups", this.ruleGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<SubscribedRuleGroupSummary> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribedRuleGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.ruleGroups(model.ruleGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<SubscribedRuleGroupSummary.Builder> getRuleGroups() {
            return this.ruleGroups != null ? (Collection)this.ruleGroups.stream().map(SubscribedRuleGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleGroups(Collection<SubscribedRuleGroupSummary> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(SubscribedRuleGroupSummary ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (SubscribedRuleGroupSummary)((SubscribedRuleGroupSummary.Builder)SubscribedRuleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuleGroups(Collection<SubscribedRuleGroupSummary.BuilderImpl> ruleGroups) {
            this.ruleGroups = SubscribedRuleGroupSummariesCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public ListSubscribedRuleGroupsResponse build() {
            return new ListSubscribedRuleGroupsResponse(this);
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    CopyableBuilder<Builder, ListSubscribedRuleGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder ruleGroups(Collection<SubscribedRuleGroupSummary> var1);

        public Builder ruleGroups(SubscribedRuleGroupSummary ... var1);

        public Builder ruleGroups(Consumer<SubscribedRuleGroupSummary.Builder> ... var1);
    }
}

