/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RuleSummariesCopier;
import software.amazon.awssdk.services.waf.model.RuleSummary;
import software.amazon.awssdk.services.waf.model.WafResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRateBasedRulesResponse
extends WafResponse
implements ToCopyableBuilder<Builder, ListRateBasedRulesResponse> {
    private final String nextMarker;
    private final List<RuleSummary> rules;

    private ListRateBasedRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.rules = builder.rules;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<RuleSummary> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRateBasedRulesResponse)) {
            return false;
        }
        ListRateBasedRulesResponse other = (ListRateBasedRulesResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"ListRateBasedRulesResponse").add("NextMarker", (Object)this.nextMarker()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WafResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RuleSummary> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRateBasedRulesResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.rules(model.rules);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<RuleSummary.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(RuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleSummary.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleSummary)((RuleSummary.Builder)RuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        @Override
        public ListRateBasedRulesResponse build() {
            return new ListRateBasedRulesResponse(this);
        }
    }

    public static interface Builder
    extends WafResponse.Builder,
    CopyableBuilder<Builder, ListRateBasedRulesResponse> {
        public Builder nextMarker(String var1);

        public Builder rules(Collection<RuleSummary> var1);

        public Builder rules(RuleSummary ... var1);

        public Builder rules(Consumer<RuleSummary.Builder> ... var1);
    }
}

