/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.WebACLSummary;

@SdkInternalApi
public class WebACLSummaryMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final WebACLSummaryMarshaller instance = new WebACLSummaryMarshaller();

    public static WebACLSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(WebACLSummary webACLSummary, ProtocolMarshaller protocolMarshaller) {
        if (webACLSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)webACLSummary.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)webACLSummary.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

