/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.services.waf.transform.XssMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class XssMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, XssMatchSetUpdate> {
    private final String action;
    private final XssMatchTuple xssMatchTuple;

    private XssMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.xssMatchTuple = builder.xssMatchTuple;
    }

    public String action() {
        return this.action;
    }

    public XssMatchTuple xssMatchTuple() {
        return this.xssMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.xssMatchTuple() == null ? 0 : this.xssMatchTuple().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSetUpdate)) {
            return false;
        }
        XssMatchSetUpdate other = (XssMatchSetUpdate)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.xssMatchTuple() == null ^ this.xssMatchTuple() == null) {
            return false;
        }
        return other.xssMatchTuple() == null || other.xssMatchTuple().equals(this.xssMatchTuple());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.xssMatchTuple() != null) {
            sb.append("XssMatchTuple: ").append(this.xssMatchTuple()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        XssMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private XssMatchTuple xssMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSetUpdate model) {
            this.setAction(model.action);
            this.setXssMatchTuple(model.xssMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final XssMatchTuple getXssMatchTuple() {
            return this.xssMatchTuple;
        }

        @Override
        public final Builder xssMatchTuple(XssMatchTuple xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple;
            return this;
        }

        public final void setXssMatchTuple(XssMatchTuple xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple;
        }

        public XssMatchSetUpdate build() {
            return new XssMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, XssMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder xssMatchTuple(XssMatchTuple var1);
    }
}

