/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSqlInjectionMatchSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
    private final String sqlInjectionMatchSetId;
    private final String changeToken;
    private final List<SqlInjectionMatchSetUpdate> updates;

    private UpdateSqlInjectionMatchSetRequest(BuilderImpl builder) {
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String sqlInjectionMatchSetId() {
        return this.sqlInjectionMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<SqlInjectionMatchSetUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sqlInjectionMatchSetId() == null ? 0 : this.sqlInjectionMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSqlInjectionMatchSetRequest)) {
            return false;
        }
        UpdateSqlInjectionMatchSetRequest other = (UpdateSqlInjectionMatchSetRequest)((Object)obj);
        if (other.sqlInjectionMatchSetId() == null ^ this.sqlInjectionMatchSetId() == null) {
            return false;
        }
        if (other.sqlInjectionMatchSetId() != null && !other.sqlInjectionMatchSetId().equals(this.sqlInjectionMatchSetId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        return other.updates() == null || other.updates().equals(this.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sqlInjectionMatchSetId() != null) {
            sb.append("SqlInjectionMatchSetId: ").append(this.sqlInjectionMatchSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sqlInjectionMatchSetId;
        private String changeToken;
        private List<SqlInjectionMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSqlInjectionMatchSetRequest model) {
            this.setSqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
        }

        public final String getSqlInjectionMatchSetId() {
            return this.sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<SqlInjectionMatchSetUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<SqlInjectionMatchSetUpdate> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SqlInjectionMatchSetUpdate ... updates) {
            if (this.updates == null) {
                this.updates = new ArrayList<SqlInjectionMatchSetUpdate>(updates.length);
            }
            for (SqlInjectionMatchSetUpdate e : updates) {
                this.updates.add(e);
            }
            return this;
        }

        public final void setUpdates(Collection<SqlInjectionMatchSetUpdate> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copy(updates);
        }

        @SafeVarargs
        public final void setUpdates(SqlInjectionMatchSetUpdate ... updates) {
            if (this.updates == null) {
                this.updates = new ArrayList<SqlInjectionMatchSetUpdate>(updates.length);
            }
            for (SqlInjectionMatchSetUpdate e : updates) {
                this.updates.add(e);
            }
        }

        public UpdateSqlInjectionMatchSetRequest build() {
            return new UpdateSqlInjectionMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
        public Builder sqlInjectionMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SqlInjectionMatchSetUpdate> var1);

        public Builder updates(SqlInjectionMatchSetUpdate ... var1);
    }
}

