/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.ByteMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListByteMatchSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListByteMatchSetsResponse> {
    private final String nextMarker;
    private final List<ByteMatchSetSummary> byteMatchSets;

    private ListByteMatchSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.byteMatchSets = builder.byteMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<ByteMatchSetSummary> byteMatchSets() {
        return this.byteMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.byteMatchSets() == null ? 0 : this.byteMatchSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListByteMatchSetsResponse)) {
            return false;
        }
        ListByteMatchSetsResponse other = (ListByteMatchSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.byteMatchSets() == null ^ this.byteMatchSets() == null) {
            return false;
        }
        return other.byteMatchSets() == null || other.byteMatchSets().equals(this.byteMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.byteMatchSets() != null) {
            sb.append("ByteMatchSets: ").append(this.byteMatchSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ByteMatchSetSummary> byteMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListByteMatchSetsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setByteMatchSets(model.byteMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<ByteMatchSetSummary> getByteMatchSets() {
            return this.byteMatchSets;
        }

        @Override
        public final Builder byteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copy(byteMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchSets(ByteMatchSetSummary ... byteMatchSets) {
            if (this.byteMatchSets == null) {
                this.byteMatchSets = new ArrayList<ByteMatchSetSummary>(byteMatchSets.length);
            }
            for (ByteMatchSetSummary e : byteMatchSets) {
                this.byteMatchSets.add(e);
            }
            return this;
        }

        public final void setByteMatchSets(Collection<ByteMatchSetSummary> byteMatchSets) {
            this.byteMatchSets = ByteMatchSetSummariesCopier.copy(byteMatchSets);
        }

        @SafeVarargs
        public final void setByteMatchSets(ByteMatchSetSummary ... byteMatchSets) {
            if (this.byteMatchSets == null) {
                this.byteMatchSets = new ArrayList<ByteMatchSetSummary>(byteMatchSets.length);
            }
            for (ByteMatchSetSummary e : byteMatchSets) {
                this.byteMatchSets.add(e);
            }
        }

        public ListByteMatchSetsResponse build() {
            return new ListByteMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListByteMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder byteMatchSets(Collection<ByteMatchSetSummary> var1);

        public Builder byteMatchSets(ByteMatchSetSummary ... var1);
    }
}

