/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkResourceAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNetworkResourceAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNetworkResourceAssociationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::id)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::arn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::statusAsString)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::createdBy)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::createdAt)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationId").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationId)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationId").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationArn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationArn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArn").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationName").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationName)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationName").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkId").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkId)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkArn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkName").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkName)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::dnsEntry)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<DnsEntry> PRIVATE_DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("privateDnsEntry").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::privateDnsEntry)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::privateDnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEntry").build()}).build();
    private static final SdkField<Boolean> IS_MANAGED_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isManagedAssociation").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::isManagedAssociation)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::isManagedAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isManagedAssociation").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::failureCode)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, STATUS_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, RESOURCE_CONFIGURATION_ID_FIELD, RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_CONFIGURATION_NAME_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_NAME_FIELD, DNS_ENTRY_FIELD, PRIVATE_DNS_ENTRY_FIELD, IS_MANAGED_ASSOCIATION_FIELD, FAILURE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceNetworkResourceAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String status;
    private final String createdBy;
    private final Instant createdAt;
    private final String resourceConfigurationId;
    private final String resourceConfigurationArn;
    private final String resourceConfigurationName;
    private final String serviceNetworkId;
    private final String serviceNetworkArn;
    private final String serviceNetworkName;
    private final DnsEntry dnsEntry;
    private final DnsEntry privateDnsEntry;
    private final Boolean isManagedAssociation;
    private final String failureCode;

    private ServiceNetworkResourceAssociationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.resourceConfigurationId = builder.resourceConfigurationId;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceConfigurationName = builder.resourceConfigurationName;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.dnsEntry = builder.dnsEntry;
        this.privateDnsEntry = builder.privateDnsEntry;
        this.isManagedAssociation = builder.isManagedAssociation;
        this.failureCode = builder.failureCode;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final ServiceNetworkResourceAssociationStatus status() {
        return ServiceNetworkResourceAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String resourceConfigurationId() {
        return this.resourceConfigurationId;
    }

    public final String resourceConfigurationArn() {
        return this.resourceConfigurationArn;
    }

    public final String resourceConfigurationName() {
        return this.resourceConfigurationName;
    }

    public final String serviceNetworkId() {
        return this.serviceNetworkId;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final DnsEntry privateDnsEntry() {
        return this.privateDnsEntry;
    }

    public final Boolean isManagedAssociation() {
        return this.isManagedAssociation;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.isManagedAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkResourceAssociationSummary)) {
            return false;
        }
        ServiceNetworkResourceAssociationSummary other = (ServiceNetworkResourceAssociationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.resourceConfigurationId(), other.resourceConfigurationId()) && Objects.equals(this.resourceConfigurationArn(), other.resourceConfigurationArn()) && Objects.equals(this.resourceConfigurationName(), other.resourceConfigurationName()) && Objects.equals(this.serviceNetworkId(), other.serviceNetworkId()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.privateDnsEntry(), other.privateDnsEntry()) && Objects.equals(this.isManagedAssociation(), other.isManagedAssociation()) && Objects.equals(this.failureCode(), other.failureCode());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNetworkResourceAssociationSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("ResourceConfigurationId", (Object)this.resourceConfigurationId()).add("ResourceConfigurationArn", (Object)this.resourceConfigurationArn()).add("ResourceConfigurationName", (Object)this.resourceConfigurationName()).add("ServiceNetworkId", (Object)this.serviceNetworkId()).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("DnsEntry", (Object)this.dnsEntry()).add("PrivateDnsEntry", (Object)this.privateDnsEntry()).add("IsManagedAssociation", (Object)this.isManagedAssociation()).add("FailureCode", (Object)this.failureCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "resourceConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationId()));
            }
            case "resourceConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationArn()));
            }
            case "resourceConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationName()));
            }
            case "serviceNetworkId": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkId()));
            }
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "serviceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "privateDnsEntry": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEntry()));
            }
            case "isManagedAssociation": {
                return Optional.ofNullable(clazz.cast(this.isManagedAssociation()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("resourceConfigurationId", RESOURCE_CONFIGURATION_ID_FIELD);
        map.put("resourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("resourceConfigurationName", RESOURCE_CONFIGURATION_NAME_FIELD);
        map.put("serviceNetworkId", SERVICE_NETWORK_ID_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("serviceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("privateDnsEntry", PRIVATE_DNS_ENTRY_FIELD);
        map.put("isManagedAssociation", IS_MANAGED_ASSOCIATION_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkResourceAssociationSummary, T> g) {
        return obj -> g.apply((ServiceNetworkResourceAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private String createdBy;
        private Instant createdAt;
        private String resourceConfigurationId;
        private String resourceConfigurationArn;
        private String resourceConfigurationName;
        private String serviceNetworkId;
        private String serviceNetworkArn;
        private String serviceNetworkName;
        private DnsEntry dnsEntry;
        private DnsEntry privateDnsEntry;
        private Boolean isManagedAssociation;
        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkResourceAssociationSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.resourceConfigurationId(model.resourceConfigurationId);
            this.resourceConfigurationArn(model.resourceConfigurationArn);
            this.resourceConfigurationName(model.resourceConfigurationName);
            this.serviceNetworkId(model.serviceNetworkId);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.serviceNetworkName(model.serviceNetworkName);
            this.dnsEntry(model.dnsEntry);
            this.privateDnsEntry(model.privateDnsEntry);
            this.isManagedAssociation(model.isManagedAssociation);
            this.failureCode(model.failureCode);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkResourceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getResourceConfigurationId() {
            return this.resourceConfigurationId;
        }

        public final void setResourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
        }

        @Override
        public final Builder resourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return this.resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceConfigurationName() {
            return this.resourceConfigurationName;
        }

        public final void setResourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
        }

        @Override
        public final Builder resourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
            return this;
        }

        public final String getServiceNetworkId() {
            return this.serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final DnsEntry.Builder getPrivateDnsEntry() {
            return this.privateDnsEntry != null ? this.privateDnsEntry.toBuilder() : null;
        }

        public final void setPrivateDnsEntry(DnsEntry.BuilderImpl privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry != null ? privateDnsEntry.build() : null;
        }

        @Override
        public final Builder privateDnsEntry(DnsEntry privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry;
            return this;
        }

        public final Boolean getIsManagedAssociation() {
            return this.isManagedAssociation;
        }

        public final void setIsManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
        }

        @Override
        public final Builder isManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public ServiceNetworkResourceAssociationSummary build() {
            return new ServiceNetworkResourceAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNetworkResourceAssociationSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkResourceAssociationStatus var1);

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder resourceConfigurationId(String var1);

        public Builder resourceConfigurationArn(String var1);

        public Builder resourceConfigurationName(String var1);

        public Builder serviceNetworkId(String var1);

        public Builder serviceNetworkArn(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder privateDnsEntry(DnsEntry var1);

        default public Builder privateDnsEntry(Consumer<DnsEntry.Builder> privateDnsEntry) {
            return this.privateDnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(privateDnsEntry)).build());
        }

        public Builder isManagedAssociation(Boolean var1);

        public Builder failureCode(String var1);
    }
}

