/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.PortRangeListCopier;
import software.amazon.awssdk.services.vpclattice.model.ProtocolType;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationDefinition;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationType;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceConfigurationRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, CreateResourceConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::name)).setter(CreateResourceConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::typeAsString)).setter(CreateResourceConfigurationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portRanges").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::portRanges)).setter(CreateResourceConfigurationRequest.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::protocolAsString)).setter(CreateResourceConfigurationRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayIdentifier").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::resourceGatewayIdentifier)).setter(CreateResourceConfigurationRequest.setter(Builder::resourceGatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationGroupIdentifier").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::resourceConfigurationGroupIdentifier)).setter(CreateResourceConfigurationRequest.setter(Builder::resourceConfigurationGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupIdentifier").build()}).build();
    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfigurationDefinition").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::resourceConfigurationDefinition)).setter(CreateResourceConfigurationRequest.setter(Builder::resourceConfigurationDefinition)).constructor(ResourceConfigurationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition").build()}).build();
    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowAssociationToShareableServiceNetwork").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::allowAssociationToShareableServiceNetwork)).setter(CreateResourceConfigurationRequest.setter(Builder::allowAssociationToShareableServiceNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAssociationToShareableServiceNetwork").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::clientToken)).setter(CreateResourceConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateResourceConfigurationRequest.getter(CreateResourceConfigurationRequest::tags)).setter(CreateResourceConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, RESOURCE_GATEWAY_IDENTIFIER_FIELD, RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD, ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateResourceConfigurationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String type;
    private final List<String> portRanges;
    private final String protocol;
    private final String resourceGatewayIdentifier;
    private final String resourceConfigurationGroupIdentifier;
    private final ResourceConfigurationDefinition resourceConfigurationDefinition;
    private final Boolean allowAssociationToShareableServiceNetwork;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateResourceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.resourceGatewayIdentifier = builder.resourceGatewayIdentifier;
        this.resourceConfigurationGroupIdentifier = builder.resourceConfigurationGroupIdentifier;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<String> portRanges() {
        return this.portRanges;
    }

    public final ProtocolType protocol() {
        return ProtocolType.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String resourceGatewayIdentifier() {
        return this.resourceGatewayIdentifier;
    }

    public final String resourceConfigurationGroupIdentifier() {
        return this.resourceConfigurationGroupIdentifier;
    }

    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return this.resourceConfigurationDefinition;
    }

    public final Boolean allowAssociationToShareableServiceNetwork() {
        return this.allowAssociationToShareableServiceNetwork;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceConfigurationRequest)) {
            return false;
        }
        CreateResourceConfigurationRequest other = (CreateResourceConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.resourceGatewayIdentifier(), other.resourceGatewayIdentifier()) && Objects.equals(this.resourceConfigurationGroupIdentifier(), other.resourceConfigurationGroupIdentifier()) && Objects.equals(this.resourceConfigurationDefinition(), other.resourceConfigurationDefinition()) && Objects.equals(this.allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceConfigurationRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("Protocol", (Object)this.protocolAsString()).add("ResourceGatewayIdentifier", (Object)this.resourceGatewayIdentifier()).add("ResourceConfigurationGroupIdentifier", (Object)this.resourceConfigurationGroupIdentifier()).add("ResourceConfigurationDefinition", (Object)this.resourceConfigurationDefinition()).add("AllowAssociationToShareableServiceNetwork", (Object)this.allowAssociationToShareableServiceNetwork()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "portRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "resourceGatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayIdentifier()));
            }
            case "resourceConfigurationGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupIdentifier()));
            }
            case "resourceConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationDefinition()));
            }
            case "allowAssociationToShareableServiceNetwork": {
                return Optional.ofNullable(clazz.cast(this.allowAssociationToShareableServiceNetwork()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("resourceGatewayIdentifier", RESOURCE_GATEWAY_IDENTIFIER_FIELD);
        map.put("resourceConfigurationGroupIdentifier", RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateResourceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private String resourceGatewayIdentifier;
        private String resourceConfigurationGroupIdentifier;
        private ResourceConfigurationDefinition resourceConfigurationDefinition;
        private Boolean allowAssociationToShareableServiceNetwork;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.portRanges(model.portRanges);
            this.protocol(model.protocol);
            this.resourceGatewayIdentifier(model.resourceGatewayIdentifier);
            this.resourceConfigurationGroupIdentifier(model.resourceConfigurationGroupIdentifier);
            this.resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            this.allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (this.portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getResourceGatewayIdentifier() {
            return this.resourceGatewayIdentifier;
        }

        public final void setResourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
        }

        @Override
        public final Builder resourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
            return this;
        }

        public final String getResourceConfigurationGroupIdentifier() {
            return this.resourceConfigurationGroupIdentifier;
        }

        public final void setResourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
        }

        @Override
        public final Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return this.resourceConfigurationDefinition != null ? this.resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition.build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return this.allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceConfigurationRequest build() {
            return new CreateResourceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceConfigurationRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ResourceConfigurationType var1);

        public Builder portRanges(Collection<String> var1);

        public Builder portRanges(String ... var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolType var1);

        public Builder resourceGatewayIdentifier(String var1);

        public Builder resourceConfigurationGroupIdentifier(String var1);

        public Builder resourceConfigurationDefinition(ResourceConfigurationDefinition var1);

        default public Builder resourceConfigurationDefinition(Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return this.resourceConfigurationDefinition((ResourceConfigurationDefinition)((ResourceConfigurationDefinition.Builder)ResourceConfigurationDefinition.builder().applyMutation(resourceConfigurationDefinition)).build());
        }

        public Builder allowAssociationToShareableServiceNetwork(Boolean var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

