/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.DnsEntry;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkResourceAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNetworkResourceAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNetworkResourceAssociationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::arn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::createdAt)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::createdBy)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsEntry").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::dnsEntry)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::dnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::failureCode)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::id)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> IS_MANAGED_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isManagedAssociation").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::isManagedAssociation)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::isManagedAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isManagedAssociation").build()}).build();
    private static final SdkField<DnsEntry> PRIVATE_DNS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("privateDnsEntry").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::privateDnsEntry)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::privateDnsEntry)).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEntry").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationArn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationArn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArn").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationId").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationId)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationId").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationName").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::resourceConfigurationName)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::resourceConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationName").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkArn").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkArn)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkId").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkId)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkName").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::serviceNetworkName)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::serviceNetworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceNetworkResourceAssociationSummary.getter(ServiceNetworkResourceAssociationSummary::statusAsString)).setter(ServiceNetworkResourceAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DNS_ENTRY_FIELD, FAILURE_CODE_FIELD, ID_FIELD, IS_MANAGED_ASSOCIATION_FIELD, PRIVATE_DNS_ENTRY_FIELD, RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_CONFIGURATION_ID_FIELD, RESOURCE_CONFIGURATION_NAME_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceNetworkResourceAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String createdBy;
    private final DnsEntry dnsEntry;
    private final String failureCode;
    private final String id;
    private final Boolean isManagedAssociation;
    private final DnsEntry privateDnsEntry;
    private final String resourceConfigurationArn;
    private final String resourceConfigurationId;
    private final String resourceConfigurationName;
    private final String serviceNetworkArn;
    private final String serviceNetworkId;
    private final String serviceNetworkName;
    private final String status;

    private ServiceNetworkResourceAssociationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.dnsEntry = builder.dnsEntry;
        this.failureCode = builder.failureCode;
        this.id = builder.id;
        this.isManagedAssociation = builder.isManagedAssociation;
        this.privateDnsEntry = builder.privateDnsEntry;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceConfigurationId = builder.resourceConfigurationId;
        this.resourceConfigurationName = builder.resourceConfigurationName;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final DnsEntry dnsEntry() {
        return this.dnsEntry;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String id() {
        return this.id;
    }

    public final Boolean isManagedAssociation() {
        return this.isManagedAssociation;
    }

    public final DnsEntry privateDnsEntry() {
        return this.privateDnsEntry;
    }

    public final String resourceConfigurationArn() {
        return this.resourceConfigurationArn;
    }

    public final String resourceConfigurationId() {
        return this.resourceConfigurationId;
    }

    public final String resourceConfigurationName() {
        return this.resourceConfigurationName;
    }

    public final String serviceNetworkArn() {
        return this.serviceNetworkArn;
    }

    public final String serviceNetworkId() {
        return this.serviceNetworkId;
    }

    public final String serviceNetworkName() {
        return this.serviceNetworkName;
    }

    public final ServiceNetworkResourceAssociationStatus status() {
        return ServiceNetworkResourceAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isManagedAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkResourceAssociationSummary)) {
            return false;
        }
        ServiceNetworkResourceAssociationSummary other = (ServiceNetworkResourceAssociationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.dnsEntry(), other.dnsEntry()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isManagedAssociation(), other.isManagedAssociation()) && Objects.equals(this.privateDnsEntry(), other.privateDnsEntry()) && Objects.equals(this.resourceConfigurationArn(), other.resourceConfigurationArn()) && Objects.equals(this.resourceConfigurationId(), other.resourceConfigurationId()) && Objects.equals(this.resourceConfigurationName(), other.resourceConfigurationName()) && Objects.equals(this.serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(this.serviceNetworkId(), other.serviceNetworkId()) && Objects.equals(this.serviceNetworkName(), other.serviceNetworkName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNetworkResourceAssociationSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DnsEntry", (Object)this.dnsEntry()).add("FailureCode", (Object)this.failureCode()).add("Id", (Object)this.id()).add("IsManagedAssociation", (Object)this.isManagedAssociation()).add("PrivateDnsEntry", (Object)this.privateDnsEntry()).add("ResourceConfigurationArn", (Object)this.resourceConfigurationArn()).add("ResourceConfigurationId", (Object)this.resourceConfigurationId()).add("ResourceConfigurationName", (Object)this.resourceConfigurationName()).add("ServiceNetworkArn", (Object)this.serviceNetworkArn()).add("ServiceNetworkId", (Object)this.serviceNetworkId()).add("ServiceNetworkName", (Object)this.serviceNetworkName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "dnsEntry": {
                return Optional.ofNullable(clazz.cast(this.dnsEntry()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "isManagedAssociation": {
                return Optional.ofNullable(clazz.cast(this.isManagedAssociation()));
            }
            case "privateDnsEntry": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEntry()));
            }
            case "resourceConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationArn()));
            }
            case "resourceConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationId()));
            }
            case "resourceConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationName()));
            }
            case "serviceNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkArn()));
            }
            case "serviceNetworkId": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkId()));
            }
            case "serviceNetworkName": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("id", ID_FIELD);
        map.put("isManagedAssociation", IS_MANAGED_ASSOCIATION_FIELD);
        map.put("privateDnsEntry", PRIVATE_DNS_ENTRY_FIELD);
        map.put("resourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("resourceConfigurationId", RESOURCE_CONFIGURATION_ID_FIELD);
        map.put("resourceConfigurationName", RESOURCE_CONFIGURATION_NAME_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("serviceNetworkId", SERVICE_NETWORK_ID_FIELD);
        map.put("serviceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkResourceAssociationSummary, T> g) {
        return obj -> g.apply((ServiceNetworkResourceAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String createdBy;
        private DnsEntry dnsEntry;
        private String failureCode;
        private String id;
        private Boolean isManagedAssociation;
        private DnsEntry privateDnsEntry;
        private String resourceConfigurationArn;
        private String resourceConfigurationId;
        private String resourceConfigurationName;
        private String serviceNetworkArn;
        private String serviceNetworkId;
        private String serviceNetworkName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkResourceAssociationSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.dnsEntry(model.dnsEntry);
            this.failureCode(model.failureCode);
            this.id(model.id);
            this.isManagedAssociation(model.isManagedAssociation);
            this.privateDnsEntry(model.privateDnsEntry);
            this.resourceConfigurationArn(model.resourceConfigurationArn);
            this.resourceConfigurationId(model.resourceConfigurationId);
            this.resourceConfigurationName(model.resourceConfigurationName);
            this.serviceNetworkArn(model.serviceNetworkArn);
            this.serviceNetworkId(model.serviceNetworkId);
            this.serviceNetworkName(model.serviceNetworkName);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return this.dnsEntry != null ? this.dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsManagedAssociation() {
            return this.isManagedAssociation;
        }

        public final void setIsManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
        }

        @Override
        public final Builder isManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
            return this;
        }

        public final DnsEntry.Builder getPrivateDnsEntry() {
            return this.privateDnsEntry != null ? this.privateDnsEntry.toBuilder() : null;
        }

        public final void setPrivateDnsEntry(DnsEntry.BuilderImpl privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry != null ? privateDnsEntry.build() : null;
        }

        @Override
        public final Builder privateDnsEntry(DnsEntry privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return this.resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceConfigurationId() {
            return this.resourceConfigurationId;
        }

        public final void setResourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
        }

        @Override
        public final Builder resourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
            return this;
        }

        public final String getResourceConfigurationName() {
            return this.resourceConfigurationName;
        }

        public final void setResourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
        }

        @Override
        public final Builder resourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
            return this;
        }

        public final String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return this.serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return this.serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkResourceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ServiceNetworkResourceAssociationSummary build() {
            return new ServiceNetworkResourceAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNetworkResourceAssociationSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder dnsEntry(DnsEntry var1);

        default public Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return this.dnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(dnsEntry)).build());
        }

        public Builder failureCode(String var1);

        public Builder id(String var1);

        public Builder isManagedAssociation(Boolean var1);

        public Builder privateDnsEntry(DnsEntry var1);

        default public Builder privateDnsEntry(Consumer<DnsEntry.Builder> privateDnsEntry) {
            return this.privateDnsEntry((DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation(privateDnsEntry)).build());
        }

        public Builder resourceConfigurationArn(String var1);

        public Builder resourceConfigurationId(String var1);

        public Builder resourceConfigurationName(String var1);

        public Builder serviceNetworkArn(String var1);

        public Builder serviceNetworkId(String var1);

        public Builder serviceNetworkName(String var1);

        public Builder status(String var1);

        public Builder status(ServiceNetworkResourceAssociationStatus var1);
    }
}

