/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.PortRangeListCopier;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationDefinition;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceConfigurationRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, UpdateResourceConfigurationRequest> {
    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowAssociationToShareableServiceNetwork").getter(UpdateResourceConfigurationRequest.getter(UpdateResourceConfigurationRequest::allowAssociationToShareableServiceNetwork)).setter(UpdateResourceConfigurationRequest.setter(Builder::allowAssociationToShareableServiceNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAssociationToShareableServiceNetwork").build()}).build();
    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portRanges").getter(UpdateResourceConfigurationRequest.getter(UpdateResourceConfigurationRequest::portRanges)).setter(UpdateResourceConfigurationRequest.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfigurationDefinition").getter(UpdateResourceConfigurationRequest.getter(UpdateResourceConfigurationRequest::resourceConfigurationDefinition)).setter(UpdateResourceConfigurationRequest.setter(Builder::resourceConfigurationDefinition)).constructor(ResourceConfigurationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationIdentifier").getter(UpdateResourceConfigurationRequest.getter(UpdateResourceConfigurationRequest::resourceConfigurationIdentifier)).setter(UpdateResourceConfigurationRequest.setter(Builder::resourceConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceConfigurationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, PORT_RANGES_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD, RESOURCE_CONFIGURATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResourceConfigurationRequest.memberNameToFieldInitializer();
    private final Boolean allowAssociationToShareableServiceNetwork;
    private final List<String> portRanges;
    private final ResourceConfigurationDefinition resourceConfigurationDefinition;
    private final String resourceConfigurationIdentifier;

    private UpdateResourceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.portRanges = builder.portRanges;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.resourceConfigurationIdentifier = builder.resourceConfigurationIdentifier;
    }

    public final Boolean allowAssociationToShareableServiceNetwork() {
        return this.allowAssociationToShareableServiceNetwork;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<String> portRanges() {
        return this.portRanges;
    }

    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return this.resourceConfigurationDefinition;
    }

    public final String resourceConfigurationIdentifier() {
        return this.resourceConfigurationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceConfigurationRequest)) {
            return false;
        }
        UpdateResourceConfigurationRequest other = (UpdateResourceConfigurationRequest)((Object)obj);
        return Objects.equals(this.allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.resourceConfigurationDefinition(), other.resourceConfigurationDefinition()) && Objects.equals(this.resourceConfigurationIdentifier(), other.resourceConfigurationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceConfigurationRequest").add("AllowAssociationToShareableServiceNetwork", (Object)this.allowAssociationToShareableServiceNetwork()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("ResourceConfigurationDefinition", (Object)this.resourceConfigurationDefinition()).add("ResourceConfigurationIdentifier", (Object)this.resourceConfigurationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowAssociationToShareableServiceNetwork": {
                return Optional.ofNullable(clazz.cast(this.allowAssociationToShareableServiceNetwork()));
            }
            case "portRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "resourceConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationDefinition()));
            }
            case "resourceConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("resourceConfigurationIdentifier", RESOURCE_CONFIGURATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateResourceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private Boolean allowAssociationToShareableServiceNetwork;
        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();
        private ResourceConfigurationDefinition resourceConfigurationDefinition;
        private String resourceConfigurationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceConfigurationRequest model) {
            super(model);
            this.allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            this.portRanges(model.portRanges);
            this.resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            this.resourceConfigurationIdentifier(model.resourceConfigurationIdentifier);
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return this.allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (this.portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return this.resourceConfigurationDefinition != null ? this.resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition.build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final String getResourceConfigurationIdentifier() {
            return this.resourceConfigurationIdentifier;
        }

        public final void setResourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
        }

        @Override
        public final Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceConfigurationRequest build() {
            return new UpdateResourceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceConfigurationRequest> {
        public Builder allowAssociationToShareableServiceNetwork(Boolean var1);

        public Builder portRanges(Collection<String> var1);

        public Builder portRanges(String ... var1);

        public Builder resourceConfigurationDefinition(ResourceConfigurationDefinition var1);

        default public Builder resourceConfigurationDefinition(Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return this.resourceConfigurationDefinition((ResourceConfigurationDefinition)((ResourceConfigurationDefinition.Builder)ResourceConfigurationDefinition.builder().applyMutation(resourceConfigurationDefinition)).build());
        }

        public Builder resourceConfigurationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

