/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.ServiceArnListCopier;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupConfig;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupStatus;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupType;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTargetGroupResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, GetTargetGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::arn)).setter(GetTargetGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<TargetGroupConfig> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("config").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::config)).setter(GetTargetGroupResponse.setter(Builder::config)).constructor(TargetGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("config").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::createdAt)).setter(GetTargetGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::failureCode)).setter(GetTargetGroupResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::failureMessage)).setter(GetTargetGroupResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::id)).setter(GetTargetGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::lastUpdatedAt)).setter(GetTargetGroupResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::name)).setter(GetTargetGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> SERVICE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceArns").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::serviceArns)).setter(GetTargetGroupResponse.setter(Builder::serviceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::statusAsString)).setter(GetTargetGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetTargetGroupResponse.getter(GetTargetGroupResponse::typeAsString)).setter(GetTargetGroupResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONFIG_FIELD, CREATED_AT_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, SERVICE_ARNS_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTargetGroupResponse.memberNameToFieldInitializer();
    private final String arn;
    private final TargetGroupConfig config;
    private final Instant createdAt;
    private final String failureCode;
    private final String failureMessage;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final List<String> serviceArns;
    private final String status;
    private final String type;

    private GetTargetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.config = builder.config;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.serviceArns = builder.serviceArns;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final TargetGroupConfig config() {
        return this.config;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasServiceArns() {
        return this.serviceArns != null && !(this.serviceArns instanceof SdkAutoConstructList);
    }

    public final List<String> serviceArns() {
        return this.serviceArns;
    }

    public final TargetGroupStatus status() {
        return TargetGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TargetGroupType type() {
        return TargetGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceArns() ? this.serviceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTargetGroupResponse)) {
            return false;
        }
        GetTargetGroupResponse other = (GetTargetGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.config(), other.config()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && this.hasServiceArns() == other.hasServiceArns() && Objects.equals(this.serviceArns(), other.serviceArns()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetTargetGroupResponse").add("Arn", (Object)this.arn()).add("Config", (Object)this.config()).add("CreatedAt", (Object)this.createdAt()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("ServiceArns", this.hasServiceArns() ? this.serviceArns() : null).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serviceArns": {
                return Optional.ofNullable(clazz.cast(this.serviceArns()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("config", CONFIG_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serviceArns", SERVICE_ARNS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTargetGroupResponse, T> g) {
        return obj -> g.apply((GetTargetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private TargetGroupConfig config;
        private Instant createdAt;
        private String failureCode;
        private String failureMessage;
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private List<String> serviceArns = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTargetGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.config(model.config);
            this.createdAt(model.createdAt);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.serviceArns(model.serviceArns);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final TargetGroupConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        public final void setConfig(TargetGroupConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(TargetGroupConfig config) {
            this.config = config;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getServiceArns() {
            if (this.serviceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceArns;
        }

        public final void setServiceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
        }

        @Override
        public final Builder serviceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArns(String ... serviceArns) {
            this.serviceArns(Arrays.asList(serviceArns));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetTargetGroupResponse build() {
            return new GetTargetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTargetGroupResponse> {
        public Builder arn(String var1);

        public Builder config(TargetGroupConfig var1);

        default public Builder config(Consumer<TargetGroupConfig.Builder> config) {
            return this.config((TargetGroupConfig)((TargetGroupConfig.Builder)TargetGroupConfig.builder().applyMutation(config)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder serviceArns(Collection<String> var1);

        public Builder serviceArns(String ... var1);

        public Builder status(String var1);

        public Builder status(TargetGroupStatus var1);

        public Builder type(String var1);

        public Builder type(TargetGroupType var1);
    }
}

