/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkResourceAssociationSummary;

public class ListServiceNetworkResourceAssociationsIterable
implements SdkIterable<ListServiceNetworkResourceAssociationsResponse> {
    private final VpcLatticeClient client;
    private final ListServiceNetworkResourceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceNetworkResourceAssociationsIterable(VpcLatticeClient client, ListServiceNetworkResourceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceNetworkResourceAssociationsResponseFetcher();
    }

    public Iterator<ListServiceNetworkResourceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceNetworkResourceAssociationSummary> items() {
        Function<ListServiceNetworkResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceNetworkResourceAssociationsResponseFetcher
    implements SyncPageFetcher<ListServiceNetworkResourceAssociationsResponse> {
        private ListServiceNetworkResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceNetworkResourceAssociationsResponse nextPage(ListServiceNetworkResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkResourceAssociationsIterable.this.client.listServiceNetworkResourceAssociations(ListServiceNetworkResourceAssociationsIterable.this.firstRequest);
            }
            return ListServiceNetworkResourceAssociationsIterable.this.client.listServiceNetworkResourceAssociations((ListServiceNetworkResourceAssociationsRequest)((Object)ListServiceNetworkResourceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

