/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.PortRangeListCopier;
import software.amazon.awssdk.services.vpclattice.model.ProtocolType;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationDefinition;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationStatus;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationType;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceConfigurationResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, UpdateResourceConfigurationResponse> {
    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowAssociationToShareableServiceNetwork").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::allowAssociationToShareableServiceNetwork)).setter(UpdateResourceConfigurationResponse.setter(Builder::allowAssociationToShareableServiceNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAssociationToShareableServiceNetwork").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::arn)).setter(UpdateResourceConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::id)).setter(UpdateResourceConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::name)).setter(UpdateResourceConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portRanges").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::portRanges)).setter(UpdateResourceConfigurationResponse.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::protocolAsString)).setter(UpdateResourceConfigurationResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfigurationDefinition").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::resourceConfigurationDefinition)).setter(UpdateResourceConfigurationResponse.setter(Builder::resourceConfigurationDefinition)).constructor(ResourceConfigurationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationGroupId").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::resourceConfigurationGroupId)).setter(UpdateResourceConfigurationResponse.setter(Builder::resourceConfigurationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayId").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::resourceGatewayId)).setter(UpdateResourceConfigurationResponse.setter(Builder::resourceGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::statusAsString)).setter(UpdateResourceConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateResourceConfigurationResponse.getter(UpdateResourceConfigurationResponse::typeAsString)).setter(UpdateResourceConfigurationResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, ARN_FIELD, ID_FIELD, NAME_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, RESOURCE_GATEWAY_ID_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResourceConfigurationResponse.memberNameToFieldInitializer();
    private final Boolean allowAssociationToShareableServiceNetwork;
    private final String arn;
    private final String id;
    private final String name;
    private final List<String> portRanges;
    private final String protocol;
    private final ResourceConfigurationDefinition resourceConfigurationDefinition;
    private final String resourceConfigurationGroupId;
    private final String resourceGatewayId;
    private final String status;
    private final String type;

    private UpdateResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final Boolean allowAssociationToShareableServiceNetwork() {
        return this.allowAssociationToShareableServiceNetwork;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<String> portRanges() {
        return this.portRanges;
    }

    public final ProtocolType protocol() {
        return ProtocolType.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return this.resourceConfigurationDefinition;
    }

    public final String resourceConfigurationGroupId() {
        return this.resourceConfigurationGroupId;
    }

    public final String resourceGatewayId() {
        return this.resourceGatewayId;
    }

    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceConfigurationResponse)) {
            return false;
        }
        UpdateResourceConfigurationResponse other = (UpdateResourceConfigurationResponse)((Object)obj);
        return Objects.equals(this.allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.resourceConfigurationDefinition(), other.resourceConfigurationDefinition()) && Objects.equals(this.resourceConfigurationGroupId(), other.resourceConfigurationGroupId()) && Objects.equals(this.resourceGatewayId(), other.resourceGatewayId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceConfigurationResponse").add("AllowAssociationToShareableServiceNetwork", (Object)this.allowAssociationToShareableServiceNetwork()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("Protocol", (Object)this.protocolAsString()).add("ResourceConfigurationDefinition", (Object)this.resourceConfigurationDefinition()).add("ResourceConfigurationGroupId", (Object)this.resourceConfigurationGroupId()).add("ResourceGatewayId", (Object)this.resourceGatewayId()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowAssociationToShareableServiceNetwork": {
                return Optional.ofNullable(clazz.cast(this.allowAssociationToShareableServiceNetwork()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "portRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "resourceConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationDefinition()));
            }
            case "resourceConfigurationGroupId": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupId()));
            }
            case "resourceGatewayId": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateResourceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private Boolean allowAssociationToShareableServiceNetwork;
        private String arn;
        private String id;
        private String name;
        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private ResourceConfigurationDefinition resourceConfigurationDefinition;
        private String resourceConfigurationGroupId;
        private String resourceGatewayId;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceConfigurationResponse model) {
            super(model);
            this.allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.portRanges(model.portRanges);
            this.protocol(model.protocol);
            this.resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            this.resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            this.resourceGatewayId(model.resourceGatewayId);
            this.status(model.status);
            this.type(model.type);
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return this.allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (this.portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return this.resourceConfigurationDefinition != null ? this.resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition.build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return this.resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getResourceGatewayId() {
            return this.resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UpdateResourceConfigurationResponse build() {
            return new UpdateResourceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceConfigurationResponse> {
        public Builder allowAssociationToShareableServiceNetwork(Boolean var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder portRanges(Collection<String> var1);

        public Builder portRanges(String ... var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolType var1);

        public Builder resourceConfigurationDefinition(ResourceConfigurationDefinition var1);

        default public Builder resourceConfigurationDefinition(Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return this.resourceConfigurationDefinition((ResourceConfigurationDefinition)((ResourceConfigurationDefinition.Builder)ResourceConfigurationDefinition.builder().applyMutation(resourceConfigurationDefinition)).build());
        }

        public Builder resourceConfigurationGroupId(String var1);

        public Builder resourceGatewayId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceConfigurationStatus var1);

        public Builder type(String var1);

        public Builder type(ResourceConfigurationType var1);
    }
}

