/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceConfigurationsRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, ListResourceConfigurationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListResourceConfigurationsRequest.getter(ListResourceConfigurationsRequest::maxResults)).setter(ListResourceConfigurationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceConfigurationsRequest.getter(ListResourceConfigurationsRequest::nextToken)).setter(ListResourceConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationGroupIdentifier").getter(ListResourceConfigurationsRequest.getter(ListResourceConfigurationsRequest::resourceConfigurationGroupIdentifier)).setter(ListResourceConfigurationsRequest.setter(Builder::resourceConfigurationGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceConfigurationGroupIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayIdentifier").getter(ListResourceConfigurationsRequest.getter(ListResourceConfigurationsRequest::resourceGatewayIdentifier)).setter(ListResourceConfigurationsRequest.setter(Builder::resourceGatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceGatewayIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD, RESOURCE_GATEWAY_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("resourceConfigurationGroupIdentifier", RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD);
            this.put("resourceGatewayIdentifier", RESOURCE_GATEWAY_IDENTIFIER_FIELD);
        }
    });
    private final Integer maxResults;
    private final String nextToken;
    private final String resourceConfigurationGroupIdentifier;
    private final String resourceGatewayIdentifier;

    private ListResourceConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceConfigurationGroupIdentifier = builder.resourceConfigurationGroupIdentifier;
        this.resourceGatewayIdentifier = builder.resourceGatewayIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resourceConfigurationGroupIdentifier() {
        return this.resourceConfigurationGroupIdentifier;
    }

    public final String resourceGatewayIdentifier() {
        return this.resourceGatewayIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceConfigurationsRequest)) {
            return false;
        }
        ListResourceConfigurationsRequest other = (ListResourceConfigurationsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceConfigurationGroupIdentifier(), other.resourceConfigurationGroupIdentifier()) && Objects.equals(this.resourceGatewayIdentifier(), other.resourceGatewayIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceConfigurationsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ResourceConfigurationGroupIdentifier", (Object)this.resourceConfigurationGroupIdentifier()).add("ResourceGatewayIdentifier", (Object)this.resourceGatewayIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourceConfigurationGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupIdentifier()));
            }
            case "resourceGatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceConfigurationsRequest, T> g) {
        return obj -> g.apply((ListResourceConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String resourceConfigurationGroupIdentifier;
        private String resourceGatewayIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceConfigurationsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.resourceConfigurationGroupIdentifier(model.resourceConfigurationGroupIdentifier);
            this.resourceGatewayIdentifier(model.resourceGatewayIdentifier);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceConfigurationGroupIdentifier() {
            return this.resourceConfigurationGroupIdentifier;
        }

        public final void setResourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
        }

        @Override
        public final Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
            return this;
        }

        public final String getResourceGatewayIdentifier() {
            return this.resourceGatewayIdentifier;
        }

        public final void setResourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
        }

        @Override
        public final Builder resourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceConfigurationsRequest build() {
            return new ListResourceConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceConfigurationsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder resourceConfigurationGroupIdentifier(String var1);

        public Builder resourceGatewayIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

