/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupType;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetGroupsRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, ListTargetGroupsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTargetGroupsRequest.getter(ListTargetGroupsRequest::maxResults)).setter(ListTargetGroupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTargetGroupsRequest.getter(ListTargetGroupsRequest::nextToken)).setter(ListTargetGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> TARGET_GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetGroupType").getter(ListTargetGroupsRequest.getter(ListTargetGroupsRequest::targetGroupTypeAsString)).setter(ListTargetGroupsRequest.setter(Builder::targetGroupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetGroupType").build()}).build();
    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcIdentifier").getter(ListTargetGroupsRequest.getter(ListTargetGroupsRequest::vpcIdentifier)).setter(ListTargetGroupsRequest.setter(Builder::vpcIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TARGET_GROUP_TYPE_FIELD, VPC_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("targetGroupType", TARGET_GROUP_TYPE_FIELD);
            this.put("vpcIdentifier", VPC_IDENTIFIER_FIELD);
        }
    });
    private final Integer maxResults;
    private final String nextToken;
    private final String targetGroupType;
    private final String vpcIdentifier;

    private ListTargetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.targetGroupType = builder.targetGroupType;
        this.vpcIdentifier = builder.vpcIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final TargetGroupType targetGroupType() {
        return TargetGroupType.fromValue(this.targetGroupType);
    }

    public final String targetGroupTypeAsString() {
        return this.targetGroupType;
    }

    public final String vpcIdentifier() {
        return this.vpcIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetGroupsRequest)) {
            return false;
        }
        ListTargetGroupsRequest other = (ListTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.targetGroupTypeAsString(), other.targetGroupTypeAsString()) && Objects.equals(this.vpcIdentifier(), other.vpcIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListTargetGroupsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("TargetGroupType", (Object)this.targetGroupTypeAsString()).add("VpcIdentifier", (Object)this.vpcIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "targetGroupType": {
                return Optional.ofNullable(clazz.cast(this.targetGroupTypeAsString()));
            }
            case "vpcIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTargetGroupsRequest, T> g) {
        return obj -> g.apply((ListTargetGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String targetGroupType;
        private String vpcIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetGroupsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.targetGroupType(model.targetGroupType);
            this.vpcIdentifier(model.vpcIdentifier);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTargetGroupType() {
            return this.targetGroupType;
        }

        public final void setTargetGroupType(String targetGroupType) {
            this.targetGroupType = targetGroupType;
        }

        @Override
        public final Builder targetGroupType(String targetGroupType) {
            this.targetGroupType = targetGroupType;
            return this;
        }

        @Override
        public final Builder targetGroupType(TargetGroupType targetGroupType) {
            this.targetGroupType(targetGroupType == null ? null : targetGroupType.toString());
            return this;
        }

        public final String getVpcIdentifier() {
            return this.vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTargetGroupsRequest build() {
            return new ListTargetGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTargetGroupsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder targetGroupType(String var1);

        public Builder targetGroupType(TargetGroupType var1);

        public Builder vpcIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

