/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailure;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdateFailureListCopier;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdateSuccess;
import software.amazon.awssdk.services.vpclattice.model.RuleUpdateSuccessListCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateRuleResponse
extends VpcLatticeResponse
implements ToCopyableBuilder<Builder, BatchUpdateRuleResponse> {
    private static final SdkField<List<RuleUpdateSuccess>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(BatchUpdateRuleResponse.getter(BatchUpdateRuleResponse::successful)).setter(BatchUpdateRuleResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleUpdateSuccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RuleUpdateFailure>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unsuccessful").getter(BatchUpdateRuleResponse.getter(BatchUpdateRuleResponse::unsuccessful)).setter(BatchUpdateRuleResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsuccessful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleUpdateFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, UNSUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("successful", SUCCESSFUL_FIELD);
            this.put("unsuccessful", UNSUCCESSFUL_FIELD);
        }
    });
    private final List<RuleUpdateSuccess> successful;
    private final List<RuleUpdateFailure> unsuccessful;

    private BatchUpdateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<RuleUpdateSuccess> successful() {
        return this.successful;
    }

    public final boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public final List<RuleUpdateFailure> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessful() ? this.unsuccessful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRuleResponse)) {
            return false;
        }
        BatchUpdateRuleResponse other = (BatchUpdateRuleResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateRuleResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Unsuccessful", this.hasUnsuccessful() ? this.unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRuleResponse, T> g) {
        return obj -> g.apply((BatchUpdateRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeResponse.BuilderImpl
    implements Builder {
        private List<RuleUpdateSuccess> successful = DefaultSdkAutoConstructList.getInstance();
        private List<RuleUpdateFailure> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRuleResponse model) {
            super(model);
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final List<RuleUpdateSuccess.Builder> getSuccessful() {
            List<RuleUpdateSuccess.Builder> result = RuleUpdateSuccessListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<RuleUpdateSuccess.BuilderImpl> successful) {
            this.successful = RuleUpdateSuccessListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<RuleUpdateSuccess> successful) {
            this.successful = RuleUpdateSuccessListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(RuleUpdateSuccess ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<RuleUpdateSuccess.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (RuleUpdateSuccess)((RuleUpdateSuccess.Builder)RuleUpdateSuccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RuleUpdateFailure.Builder> getUnsuccessful() {
            List<RuleUpdateFailure.Builder> result = RuleUpdateFailureListCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<RuleUpdateFailure.BuilderImpl> unsuccessful) {
            this.unsuccessful = RuleUpdateFailureListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<RuleUpdateFailure> unsuccessful) {
            this.unsuccessful = RuleUpdateFailureListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(RuleUpdateFailure ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<RuleUpdateFailure.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (RuleUpdateFailure)((RuleUpdateFailure.Builder)RuleUpdateFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateRuleResponse build() {
            return new BatchUpdateRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateRuleResponse> {
        public Builder successful(Collection<RuleUpdateSuccess> var1);

        public Builder successful(RuleUpdateSuccess ... var1);

        public Builder successful(Consumer<RuleUpdateSuccess.Builder> ... var1);

        public Builder unsuccessful(Collection<RuleUpdateFailure> var1);

        public Builder unsuccessful(RuleUpdateFailure ... var1);

        public Builder unsuccessful(Consumer<RuleUpdateFailure.Builder> ... var1);
    }
}

