/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRuleRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, GetRuleRequest> {
    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerIdentifier").getter(GetRuleRequest.getter(GetRuleRequest::listenerIdentifier)).setter(GetRuleRequest.setter(Builder::listenerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()}).build();
    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleIdentifier").getter(GetRuleRequest.getter(GetRuleRequest::ruleIdentifier)).setter(GetRuleRequest.setter(Builder::ruleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleIdentifier").build()}).build();
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIdentifier").getter(GetRuleRequest.getter(GetRuleRequest::serviceIdentifier)).setter(GetRuleRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_IDENTIFIER_FIELD, RULE_IDENTIFIER_FIELD, SERVICE_IDENTIFIER_FIELD));
    private final String listenerIdentifier;
    private final String ruleIdentifier;
    private final String serviceIdentifier;

    private GetRuleRequest(BuilderImpl builder) {
        super(builder);
        this.listenerIdentifier = builder.listenerIdentifier;
        this.ruleIdentifier = builder.ruleIdentifier;
        this.serviceIdentifier = builder.serviceIdentifier;
    }

    public final String listenerIdentifier() {
        return this.listenerIdentifier;
    }

    public final String ruleIdentifier() {
        return this.ruleIdentifier;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleRequest)) {
            return false;
        }
        GetRuleRequest other = (GetRuleRequest)((Object)obj);
        return Objects.equals(this.listenerIdentifier(), other.listenerIdentifier()) && Objects.equals(this.ruleIdentifier(), other.ruleIdentifier()) && Objects.equals(this.serviceIdentifier(), other.serviceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetRuleRequest").add("ListenerIdentifier", (Object)this.listenerIdentifier()).add("RuleIdentifier", (Object)this.ruleIdentifier()).add("ServiceIdentifier", (Object)this.serviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "listenerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.listenerIdentifier()));
            }
            case "ruleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ruleIdentifier()));
            }
            case "serviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRuleRequest, T> g) {
        return obj -> g.apply((GetRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String listenerIdentifier;
        private String ruleIdentifier;
        private String serviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleRequest model) {
            super(model);
            this.listenerIdentifier(model.listenerIdentifier);
            this.ruleIdentifier(model.ruleIdentifier);
            this.serviceIdentifier(model.serviceIdentifier);
        }

        public final String getListenerIdentifier() {
            return this.listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final String getRuleIdentifier() {
            return this.ruleIdentifier;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRuleRequest build() {
            return new GetRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRuleRequest> {
        public Builder listenerIdentifier(String var1);

        public Builder ruleIdentifier(String var1);

        public Builder serviceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

