/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.HealthCheckProtocolVersion;
import software.amazon.awssdk.services.vpclattice.model.Matcher;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheckConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(HealthCheckConfig.getter(HealthCheckConfig::enabled)).setter(HealthCheckConfig.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthCheckIntervalSeconds").getter(HealthCheckConfig.getter(HealthCheckConfig::healthCheckIntervalSeconds)).setter(HealthCheckConfig.setter(Builder::healthCheckIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckIntervalSeconds").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthCheckTimeoutSeconds").getter(HealthCheckConfig.getter(HealthCheckConfig::healthCheckTimeoutSeconds)).setter(HealthCheckConfig.setter(Builder::healthCheckTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthyThresholdCount").getter(HealthCheckConfig.getter(HealthCheckConfig::healthyThresholdCount)).setter(HealthCheckConfig.setter(Builder::healthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthyThresholdCount").build()}).build();
    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("matcher").getter(HealthCheckConfig.getter(HealthCheckConfig::matcher)).setter(HealthCheckConfig.setter(Builder::matcher)).constructor(Matcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matcher").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(HealthCheckConfig.getter(HealthCheckConfig::path)).setter(HealthCheckConfig.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(HealthCheckConfig.getter(HealthCheckConfig::port)).setter(HealthCheckConfig.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(HealthCheckConfig.getter(HealthCheckConfig::protocolAsString)).setter(HealthCheckConfig.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolVersion").getter(HealthCheckConfig.getter(HealthCheckConfig::protocolVersionAsString)).setter(HealthCheckConfig.setter(Builder::protocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolVersion").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unhealthyThresholdCount").getter(HealthCheckConfig.getter(HealthCheckConfig::unhealthyThresholdCount)).setter(HealthCheckConfig.setter(Builder::unhealthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unhealthyThresholdCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, MATCHER_FIELD, PATH_FIELD, PORT_FIELD, PROTOCOL_FIELD, PROTOCOL_VERSION_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Matcher matcher;
    private final String path;
    private final Integer port;
    private final String protocol;
    private final String protocolVersion;
    private final Integer unhealthyThresholdCount;

    private HealthCheckConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.matcher = builder.matcher;
        this.path = builder.path;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.protocolVersion = builder.protocolVersion;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public final Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public final Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public final Matcher matcher() {
        return this.matcher;
    }

    public final String path() {
        return this.path;
    }

    public final Integer port() {
        return this.port;
    }

    public final TargetGroupProtocol protocol() {
        return TargetGroupProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final HealthCheckProtocolVersion protocolVersion() {
        return HealthCheckProtocolVersion.fromValue(this.protocolVersion);
    }

    public final String protocolVersionAsString() {
        return this.protocolVersion;
    }

    public final Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.matcher(), other.matcher()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.protocolVersionAsString(), other.protocolVersionAsString()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheckConfig").add("Enabled", (Object)this.enabled()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("Matcher", (Object)this.matcher()).add("Path", (Object)this.path()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("ProtocolVersion", (Object)this.protocolVersionAsString()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "healthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "healthCheckTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "healthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.healthyThresholdCount()));
            }
            case "matcher": {
                return Optional.ofNullable(clazz.cast(this.matcher()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "protocolVersion": {
                return Optional.ofNullable(clazz.cast(this.protocolVersionAsString()));
            }
            case "unhealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThresholdCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfig, T> g) {
        return obj -> g.apply((HealthCheckConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Matcher matcher;
        private String path;
        private Integer port;
        private String protocol;
        private String protocolVersion;
        private Integer unhealthyThresholdCount;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            this.enabled(model.enabled);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.matcher(model.matcher);
            this.path(model.path);
            this.port(model.port);
            this.protocol(model.protocol);
            this.protocolVersion(model.protocolVersion);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TargetGroupProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getProtocolVersion() {
            return this.protocolVersion;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Override
        public final Builder protocolVersion(HealthCheckProtocolVersion protocolVersion) {
            this.protocolVersion(protocolVersion == null ? null : protocolVersion.toString());
            return this;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheckConfig> {
        public Builder enabled(Boolean var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().applyMutation(matcher)).build());
        }

        public Builder path(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TargetGroupProtocol var1);

        public Builder protocolVersion(String var1);

        public Builder protocolVersion(HealthCheckProtocolVersion var1);

        public Builder unhealthyThresholdCount(Integer var1);
    }
}

