/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The codes to use when checking for a successful response from a target for health checks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Matcher implements SdkPojo, Serializable, ToCopyableBuilder<Matcher.Builder, Matcher> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpCode").getter(getter(Matcher::httpCode)).setter(setter(Builder::httpCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpCode;

    private final Type type;

    private Matcher(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
        this.type = builder.type;
    }

    /**
     * <p>
     * The HTTP code to use when checking for a successful response from a target.
     * </p>
     * 
     * @return The HTTP code to use when checking for a successful response from a target.
     */
    public final String httpCode() {
        return httpCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher) obj;
        return Objects.equals(httpCode(), other.httpCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Matcher").add("HttpCode", httpCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpCode":
            return Optional.ofNullable(clazz.cast(httpCode()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #httpCode()} initialized to the given value.
     *
     * <p>
     * The HTTP code to use when checking for a successful response from a target.
     * </p>
     * 
     * @param httpCode
     *        The HTTP code to use when checking for a successful response from a target.
     */
    public static Matcher fromHttpCode(String httpCode) {
        return builder().httpCode(httpCode).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Matcher, T> g) {
        return obj -> g.apply((Matcher) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Matcher> {
        /**
         * <p>
         * The HTTP code to use when checking for a successful response from a target.
         * </p>
         * 
         * @param httpCode
         *        The HTTP code to use when checking for a successful response from a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode(String httpCode);
    }

    static final class BuilderImpl implements Builder {
        private String httpCode;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Matcher model) {
            httpCode(model.httpCode);
        }

        public final String getHttpCode() {
            return httpCode;
        }

        public final void setHttpCode(String httpCode) {
            Object oldValue = this.httpCode;
            this.httpCode = httpCode;
            handleUnionValueChange(Type.HTTP_CODE, oldValue, this.httpCode);
        }

        @Override
        public final Builder httpCode(String httpCode) {
            Object oldValue = this.httpCode;
            this.httpCode = httpCode;
            handleUnionValueChange(Type.HTTP_CODE, oldValue, this.httpCode);
            return this;
        }

        @Override
        public Matcher build() {
            return new Matcher(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Matcher#type()
     */
    public enum Type {
        HTTP_CODE,

        UNKNOWN_TO_SDK_VERSION
    }
}
