/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTargetGroupResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<GetTargetGroupResponse.Builder, GetTargetGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetTargetGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<TargetGroupConfig> CONFIG_FIELD = SdkField
            .<TargetGroupConfig> builder(MarshallingType.SDK_POJO).memberName("config")
            .getter(getter(GetTargetGroupResponse::config)).setter(setter(Builder::config))
            .constructor(TargetGroupConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("config").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetTargetGroupResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(GetTargetGroupResponse::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetTargetGroupResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetTargetGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetTargetGroupResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTargetGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> SERVICE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceArns")
            .getter(getter(GetTargetGroupResponse::serviceArns))
            .setter(setter(Builder::serviceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTargetGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetTargetGroupResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONFIG_FIELD,
            CREATED_AT_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD,
            SERVICE_ARNS_FIELD, STATUS_FIELD, TYPE_FIELD));

    private final String arn;

    private final TargetGroupConfig config;

    private final Instant createdAt;

    private final String failureCode;

    private final String failureMessage;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String name;

    private final List<String> serviceArns;

    private final String status;

    private final String type;

    private GetTargetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.config = builder.config;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.serviceArns = builder.serviceArns;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The target group configuration.
     * </p>
     * 
     * @return The target group configuration.
     */
    public final TargetGroupConfig config() {
        return config;
    }

    /**
     * <p>
     * The date and time that the target group was created, specified in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the target group was created, specified in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * 
     * @return The failure code.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The failure message.
     * </p>
     * 
     * @return The failure message.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The ID of the target group.
     * </p>
     * 
     * @return The ID of the target group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the target group was last updated, specified in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the target group was last updated, specified in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the target group.
     * </p>
     * 
     * @return The name of the target group.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceArns() {
        return serviceArns != null && !(serviceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the service.
     */
    public final List<String> serviceArns() {
        return serviceArns;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see TargetGroupStatus
     */
    public final TargetGroupStatus status() {
        return TargetGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see TargetGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target group type.
     * @see TargetGroupType
     */
    public final TargetGroupType type() {
        return TargetGroupType.fromValue(type);
    }

    /**
     * <p>
     * The target group type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TargetGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The target group type.
     * @see TargetGroupType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceArns() ? serviceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTargetGroupResponse)) {
            return false;
        }
        GetTargetGroupResponse other = (GetTargetGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(config(), other.config())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(failureCode(), other.failureCode())
                && Objects.equals(failureMessage(), other.failureMessage()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && hasServiceArns() == other.hasServiceArns() && Objects.equals(serviceArns(), other.serviceArns())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTargetGroupResponse").add("Arn", arn()).add("Config", config()).add("CreatedAt", createdAt())
                .add("FailureCode", failureCode()).add("FailureMessage", failureMessage()).add("Id", id())
                .add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("ServiceArns", hasServiceArns() ? serviceArns() : null).add("Status", statusAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "config":
            return Optional.ofNullable(clazz.cast(config()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serviceArns":
            return Optional.ofNullable(clazz.cast(serviceArns()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTargetGroupResponse, T> g) {
        return obj -> g.apply((GetTargetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTargetGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The target group configuration.
         * </p>
         * 
         * @param config
         *        The target group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(TargetGroupConfig config);

        /**
         * <p>
         * The target group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetGroupConfig.Builder} avoiding the
         * need to create one manually via {@link TargetGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetGroupConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(TargetGroupConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link TargetGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(TargetGroupConfig)
         */
        default Builder config(Consumer<TargetGroupConfig.Builder> config) {
            return config(TargetGroupConfig.builder().applyMutation(config).build());
        }

        /**
         * <p>
         * The date and time that the target group was created, specified in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the target group was created, specified in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure message.
         * </p>
         * 
         * @param failureMessage
         *        The failure message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The ID of the target group.
         * </p>
         * 
         * @param id
         *        The ID of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the target group was last updated, specified in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time that the target group was last updated, specified in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the target group.
         * </p>
         * 
         * @param name
         *        The name of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the service.
         * </p>
         * 
         * @param serviceArns
         *        The Amazon Resource Names (ARNs) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(Collection<String> serviceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the service.
         * </p>
         * 
         * @param serviceArns
         *        The Amazon Resource Names (ARNs) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(String... serviceArns);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see TargetGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupStatus
         */
        Builder status(TargetGroupStatus status);

        /**
         * <p>
         * The target group type.
         * </p>
         * 
         * @param type
         *        The target group type.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * The target group type.
         * </p>
         * 
         * @param type
         *        The target group type.
         * @see TargetGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetGroupType
         */
        Builder type(TargetGroupType type);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String arn;

        private TargetGroupConfig config;

        private Instant createdAt;

        private String failureCode;

        private String failureMessage;

        private String id;

        private Instant lastUpdatedAt;

        private String name;

        private List<String> serviceArns = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTargetGroupResponse model) {
            super(model);
            arn(model.arn);
            config(model.config);
            createdAt(model.createdAt);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            serviceArns(model.serviceArns);
            status(model.status);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final TargetGroupConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(TargetGroupConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(TargetGroupConfig config) {
            this.config = config;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getServiceArns() {
            if (serviceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceArns;
        }

        public final void setServiceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
        }

        @Override
        public final Builder serviceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnListCopier.copy(serviceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArns(String... serviceArns) {
            serviceArns(Arrays.asList(serviceArns));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetTargetGroupResponse build() {
            return new GetTargetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
